/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.oss.minio.config;

import io.minio.MinioClient;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import org.springblade.core.oss.config.OssConfiguration;
import org.springblade.core.oss.minio.MinioTemplate;
import org.springblade.core.oss.props.OssProperties;
import org.springblade.core.oss.rule.BladeOssRule;
import org.springblade.core.oss.rule.OssRule;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={OssConfiguration.class})
@EnableConfigurationProperties(value={OssProperties.class})
@ConditionalOnProperty(value={"oss.name"}, havingValue="minio")
public class MinioConfiguration {
    private static final long DEFAULT_CONNECTION_TIMEOUT = 900L;
    private final OssProperties ossProperties;

    @Bean
    @ConditionalOnMissingBean(value={OssRule.class})
    public OssRule ossRule() {
        return new BladeOssRule(this.ossProperties.getTenantMode());
    }

    @Bean
    @ConditionalOnMissingBean(value={MinioClient.class})
    public MinioClient minioClient() {
        LinkedList<Protocol> protocol = new LinkedList<Protocol>();
        protocol.add(Protocol.HTTP_1_1);
        OkHttpClient httpClient = new OkHttpClient();
        httpClient = httpClient.newBuilder().connectTimeout(900L, TimeUnit.SECONDS).writeTimeout(900L, TimeUnit.SECONDS).readTimeout(900L, TimeUnit.SECONDS).protocols(protocol).hostnameVerifier((s, sslSession) -> true).build();
        boolean secure = this.ossProperties.getEndpoint() == null || !this.ossProperties.getEndpoint().startsWith("http://");
        return new MinioClient(this.ossProperties.getEndpoint(), 0, this.ossProperties.getAccessKey(), this.ossProperties.getSecretKey(), null, secure, httpClient);
    }

    @Bean
    @ConditionalOnBean(value={MinioClient.class, OssRule.class})
    @ConditionalOnMissingBean(value={MinioTemplate.class})
    public MinioTemplate minioTemplate(MinioClient minioClient, OssRule ossRule) {
        return new MinioTemplate(minioClient, ossRule, this.ossProperties);
    }

    public MinioConfiguration(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }
}

