/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import asposewobfuscated.zz68;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintException;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzW;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConstraintCollection
implements Iterable<Constraint> {
    private final List<Constraint> zzY6B;
    private final DataTable zzZ0O;
    private final AtomicInteger zzY6A;

    ConstraintCollection(DataTable table) {
        this.zzZ0O = table;
        this.zzY6A = new AtomicInteger(1);
        this.zzY6B = new ArrayList<Constraint>();
    }

    public Constraint get(String constraintName) {
        if (zz68.zzWm(constraintName)) {
            return null;
        }
        for (Constraint constraint : this.zzY6B) {
            if (!constraint.getConstraintName().equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint get(int idx) {
        return this.zzY6B.get(idx);
    }

    public void add(Constraint constraint) throws DataException, InvalidConstraintException {
        if (constraint == null) {
            return;
        }
        if (this == constraint.zzYWu()) {
            throw new IllegalArgumentException("Constraint already belongs to this collection.");
        }
        if (null != constraint.zzYWu()) {
            throw new IllegalArgumentException("Constraint already belongs to another collection.");
        }
        for (Constraint constraint2 : this) {
            if (!constraint2.equals(constraint)) continue;
            throw new DataException("Constraint matches contraint named '" + constraint2.getConstraintName() + "' already in collection");
        }
        if (this.zzZ(constraint.getConstraintName(), null)) {
            throw new DataException("Constraint name already exists.");
        }
        constraint.addToConstraintCollectionSetup(this);
        if (constraint.getConstraintName() == null || "".equals(constraint.getConstraintName())) {
            constraint.setConstraintName(this.zzYWs());
        }
        constraint.zzZ(this);
        this.zzY6B.add(constraint);
        if (constraint instanceof UniqueConstraint && ((UniqueConstraint)constraint).isPrimaryKey()) {
            this.zzZ0O.setPrimaryKey(((UniqueConstraint)constraint).getColumns());
        }
    }

    public void remove(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.zzY6B.remove(constraint);
    }

    public boolean contains(Constraint cc) {
        if (cc != null) {
            return false;
        }
        return this.zzY6B.contains(cc);
    }

    public int getCount() {
        return this.zzY6B.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.zzY6B.iterator();
    }

    DataTable getTable() {
        return this.zzZ0O;
    }

    List<ForeignKeyConstraint> zzYWt() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Constraint constraint : this.zzY6B) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            arrayList.add((ForeignKeyConstraint)constraint);
        }
        return arrayList;
    }

    void zzZ(DataRow dataRow) throws ConstraintException, InvalidConstraintException {
        for (Constraint constraint : this.zzY6B) {
            if (constraint instanceof UniqueConstraint) {
                this.zzZ((UniqueConstraint)constraint, dataRow);
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            this.zzZ((ForeignKeyConstraint)constraint, dataRow);
        }
    }

    private boolean zzZ(String string, Constraint constraint) {
        for (Constraint constraint2 : this.zzY6B) {
            if (constraint2.equals(constraint) || zz68.zzU(string, constraint2.getConstraintName(), false) != 0) continue;
            return true;
        }
        return false;
    }

    private String zzYWs() {
        return "Constraint" + this.zzY6A.getAndIncrement();
    }

    private void zzZ(UniqueConstraint uniqueConstraint, DataRow dataRow) throws ConstraintException {
        zzW zzW10 = this.zzZ0O.zzYWl().zzY(uniqueConstraint.getColumns());
        Map<String, Object> map = zzW10.zzY(dataRow);
        if (map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringBuilder.append(zz68.format("Column '{0}' is constrained to be unique.  Value '{1}' is already present.", entry.getKey(), entry.getValue()));
            }
            throw new ConstraintException(stringBuilder.toString());
        }
    }

    private void zzZ(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) throws InvalidConstraintException {
        if (this.zzZ0O.getDataSet() == null) {
            return;
        }
        DataRelationCollection dataRelationCollection = this.zzZ0O.getDataSet().getRelations();
        if (dataRelationCollection.getCount() == 0) {
            return;
        }
        if (foreignKeyConstraint.getRelatedTable().getTableName().equals(this.getTable().getTableName())) {
            return;
        }
        if (!foreignKeyConstraint.getTable().getTableName().equals(this.getTable().getTableName())) {
            return;
        }
        DataTable dataTable = foreignKeyConstraint.getRelatedTable();
        if (!dataTable.zzZ(foreignKeyConstraint.getRelatedColumns(), foreignKeyConstraint.getColumns(), dataRow)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
                stringBuilder.append(zz68.format("ForeignKeyConstraint '{0}' requires the child key values ('{1}') to exist in the parent table.", foreignKeyConstraint.getConstraintName(), dataRow.get(dataColumn)));
            }
            throw new InvalidConstraintException(stringBuilder.toString());
        }
    }
}

