/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.hnac.hzims.safeproduct.dto.AccidentDTO;
import com.hnac.hzims.safeproduct.entity.AccidentEntity;
import com.hnac.hzims.safeproduct.service.IAccidentService;
import com.hnac.hzims.safeproduct.vo.AccidentVO;
import com.hnac.hzims.safeproduct.wrapper.AccidentWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.boot.ctrl.BladeController;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.support.Condition;
import org.springblade.core.mp.support.Query;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springblade.resource.feign.IOssClient;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/accident"})
@Api(value="\u4e8b\u6545\u7ba1\u7406", tags={"\u4e8b\u6545\u7ba1\u7406"})
public class AccidentController
extends BladeController {
    private static final Logger log = LoggerFactory.getLogger(AccidentController.class);
    private final IAccidentService accidentService;
    private final IOssClient ossClient;
    private static ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
    private static ReentrantReadWriteLock.ReadLock readLock = lock.readLock();

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4e8b\u6545\u7ba1\u7406\u4fdd\u5b58")
    @ApiOperationSupport(order=1)
    public R save(@RequestBody @Valid AccidentDTO req) {
        AccidentEntity accidentEntity = (AccidentEntity)BeanUtil.copy((Object)req, AccidentEntity.class);
        this.accidentService.save((Object)accidentEntity);
        return R.data((Object)accidentEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="\u4e8b\u6545\u7ba1\u7406\u67e5\u8be2\u8be6\u60c5")
    @ApiOperationSupport(order=2)
    public R<AccidentVO> detail(@PathVariable(value="id") Long id) {
        AccidentVO accidentVO = null;
        readLock.lock();
        try {
            AccidentEntity accidentEntity = (AccidentEntity)this.accidentService.getById((Serializable)id);
            if (ObjectUtil.isNotEmpty((Object)accidentEntity)) {
                accidentVO = AccidentWrapper.build().entityVO(accidentEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            readLock.unlock();
        }
        return R.data(accidentVO);
    }

    @PostMapping(value={"updateById"})
    @ApiOperation(value="\u6839\u636eID\u4fee\u6539\u4e8b\u6545")
    @ApiOperationSupport(order=3)
    @Transactional(rollbackFor={Exception.class})
    public R updateById(@RequestBody @Valid AccidentDTO req) {
        writeLock.lock();
        try {
            AccidentEntity accidentEntity = (AccidentEntity)BeanUtil.copy((Object)req, AccidentEntity.class);
            this.accidentService.updateById((Object)accidentEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            writeLock.unlock();
        }
        return R.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @PutMapping(value={"/remove/{ids}"})
    @ApiOperation(value="\u5220\u9664\u4e8b\u6545\u7ba1\u7406\uff0cid\u6309\u9017\u53f7\u5206\u9694")
    @ApiOperationSupport(order=4)
    public R remove(@PathVariable(value="ids") @Valid String ids) {
        List idList = Func.toLongList((String)ids);
        return R.status((boolean)this.accidentService.deleteLogic(idList));
    }

    @GetMapping(value={"/pageList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=5)
    public R<IPage> pageList(AccidentDTO req, Query query) {
        IPage page;
        AccidentEntity accidentEntity = (AccidentEntity)BeanUtil.copy((Object)req, AccidentEntity.class);
        LambdaQueryWrapper queryWrapper = Condition.getQueryWrapper((Object)new AccidentEntity(), (Object)accidentEntity);
        if (ObjectUtil.isNotEmpty((Object)req.getStatus())) {
            queryWrapper.eq(BaseEntity::getStatus, (Object)req.getStatus());
        }
        if (CollectionUtil.isNotEmpty((Collection)(page = this.accidentService.page(Condition.getPage((Query)query), (Wrapper)queryWrapper)).getRecords())) {
            page.setRecords(AccidentWrapper.build().listVO(page.getRecords()));
        }
        return R.data((Object)page);
    }

    public AccidentController(IAccidentService accidentService, IOssClient ossClient) {
        this.accidentService = accidentService;
        this.ossClient = ossClient;
    }
}

