/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.hnac.hzims.safeproduct.dto.CheckQuarterDTO;
import com.hnac.hzims.safeproduct.entity.CheckQuarterEntity;
import com.hnac.hzims.safeproduct.service.ICheckQuarterService;
import com.hnac.hzims.safeproduct.vo.CheckQuarterVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import org.springblade.core.boot.ctrl.BladeController;
import org.springblade.core.mp.support.Query;
import org.springblade.core.tool.api.R;
import org.springblade.system.entity.Dept;
import org.springblade.system.feign.ISysClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/checkQuarter"})
@Api(tags={"\u5b63\u5ea6\u68c0\u67e5"})
public class CheckQuarterController
extends BladeController {
    private final ICheckQuarterService CheckQuarterService;
    private final ISysClient sysClient;

    @PostMapping(value={"/save"})
    @ApiOperationSupport(order=20)
    @ApiOperation(value="\u65b0\u589e", notes="\u4f20\u5165CheckQuarterDTO")
    public R save(@RequestBody CheckQuarterDTO req) {
        return this.CheckQuarterService.doSave(req);
    }

    @PostMapping(value={"/update"})
    @ApiOperationSupport(order=30)
    @ApiOperation(value="\u4fee\u6539", notes="\u4f20\u5165CheckQuarterDTO")
    public R update(@RequestBody CheckQuarterDTO req) {
        return R.status((boolean)this.CheckQuarterService.doUpdate(req));
    }

    @PostMapping(value={"/remove"})
    @ApiOperationSupport(order=10)
    @ApiOperation(value="\u903b\u8f91\u5220\u9664", notes="\u4f20\u5165ids")
    public R remove(@ApiParam(value="\u4e3b\u952e\u96c6\u5408", required=true) @RequestParam String ids) {
        return R.status((boolean)this.CheckQuarterService.doDelete(ids));
    }

    @GetMapping(value={"/detail"})
    @ApiOperationSupport(order=40)
    @ApiOperation(value="\u8be6\u60c5", notes="\u4f20\u5165id")
    public R<CheckQuarterVo> detail(@RequestParam Long id) {
        return this.CheckQuarterService.detail(id);
    }

    @GetMapping(value={"/list"})
    @ApiOperationSupport(order=50)
    @ApiOperation(value="\u5206\u9875", notes="\u67e5\u8be2\u6761\u4ef6\uff1aquarter,status,createDept")
    public R<IPage<CheckQuarterVo>> list(CheckQuarterEntity req, Query query) {
        R pageR = this.CheckQuarterService.pageCondition(req, query);
        IPage page = (IPage)pageR.getData();
        page.getRecords().forEach(quarterVo -> {
            R deptR = this.sysClient.getDept(quarterVo.getCreateDept());
            if (deptR.isSuccess()) {
                quarterVo.setDeptName((String)Optional.ofNullable(deptR.getData()).map(Dept::getDeptName).orElse(null));
            }
        });
        return R.data((Object)page);
    }

    @GetMapping(value={"/listNotDataScope"})
    @ApiOperationSupport(order=50)
    @ApiOperation(value="\u5206\u9875", notes="\u67e5\u8be2\u6761\u4ef6\uff1aquarter,status,createDept")
    public R<IPage<CheckQuarterVo>> listNotDataScope(CheckQuarterEntity req, Query query) {
        R pageR = this.CheckQuarterService.pageNotDataScope(req, query);
        IPage page = (IPage)pageR.getData();
        page.getRecords().forEach(quarterVo -> {
            R deptR = this.sysClient.getDept(quarterVo.getCreateDept());
            if (deptR.isSuccess()) {
                quarterVo.setDeptName((String)Optional.ofNullable(deptR.getData()).map(Dept::getDeptName).orElse(null));
            }
        });
        return R.data((Object)page);
    }

    public CheckQuarterController(ICheckQuarterService CheckQuarterService, ISysClient sysClient) {
        this.CheckQuarterService = CheckQuarterService;
        this.sysClient = sysClient;
    }
}

