/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.hnac.hzims.safeproduct.Constants;
import com.hnac.hzims.safeproduct.dto.ReviewDto;
import com.hnac.hzims.safeproduct.entity.ReviewEntity;
import com.hnac.hzims.safeproduct.entity.ReviewStandardEntity;
import com.hnac.hzims.safeproduct.service.IReviewService;
import com.hnac.hzims.safeproduct.service.IReviewStandardService;
import com.hnac.hzims.safeproduct.vo.ReviewVo;
import com.hnac.hzims.safeproduct.wrapper.ReviewWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.boot.ctrl.BladeController;
import org.springblade.core.log.exception.ServiceException;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.support.Condition;
import org.springblade.core.mp.support.Query;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springblade.system.user.entity.User;
import org.springblade.system.user.feign.IUserClient;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/review"})
@Api(value="\u7ad9\u70b9\u5b89\u5168\u751f\u4ea7\u6807\u51c6\u5316\u8bc4\u5ba1\u7ba1\u7406", tags={"\u7ad9\u70b9\u5b89\u5168\u751f\u4ea7\u6807\u51c6\u5316\u8bc4\u5ba1\u7ba1\u7406"})
public class ReviewController
extends BladeController {
    private static final Logger log = LoggerFactory.getLogger(ReviewController.class);
    private final IReviewService reviewService;
    private final IUserClient userClient;
    private final IReviewStandardService reviewStandardService;

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58")
    @ApiOperationSupport(order=1)
    public R<Boolean> save(@RequestBody ReviewDto req) {
        LocalDateTime lastDayOfYear = LocalDateTime.now().with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime firstDayOfYear = LocalDateTime.now().with(TemporalAdjusters.firstDayOfYear());
        LambdaQueryWrapper qw = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ReviewEntity::getStationCode, (Object)req.getStationCode())).ge(BaseEntity::getCreateTime, (Object)firstDayOfYear)).le(BaseEntity::getCreateTime, (Object)lastDayOfYear)).ne(BaseEntity::getStatus, (Object)Constants.REVIEW_NOT_PASS_STATUS)).last("limit 1;");
        ReviewEntity reviewEntity = (ReviewEntity)this.reviewService.getOne((Wrapper)qw);
        Assert.isTrue((boolean)ObjectUtil.isEmpty((Object)reviewEntity), () -> {
            throw new ServiceException("\u8be5\u7ad9\u70b9\u5df2\u5f55\u5165\u6570\u636e\uff0c\u65e0\u6cd5\u91cd\u590d\u5f55\u5165");
        });
        ReviewEntity entity = (ReviewEntity)BeanUtil.copy((Object)req, ReviewEntity.class);
        this.reviewService.save((Object)entity);
        req.getReviewStandardEntityList().stream().forEach(reviewStandardEntity -> reviewStandardEntity.setReviewId(entity.getId()));
        this.reviewStandardService.saveOrUpdateBatch((Collection)req.getReviewStandardEntityList());
        return R.status((boolean)true);
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u7f16\u8f91/\u63d0\u4ea4/\u8bc4\u5ba1")
    @ApiOperationSupport(order=2)
    @Transactional(rollbackFor={Exception.class})
    public R<Boolean> update(@RequestBody ReviewDto req) {
        ReviewEntity entity = (ReviewEntity)BeanUtil.copy((Object)req, ReviewEntity.class);
        if (Constants.REVIEW_SUBMIT_STATUS == entity.getStatus()) {
            entity.setSubmitter(AuthUtil.getUserId());
            entity.setSubmitTime(LocalDateTime.now());
            R userListResult = this.userClient.relationUserListByRoleAlias(AuthUtil.getTenantId(), req.getCreateDept(), "stationAgent");
            if (userListResult.isSuccess()) {
                Optional<User> agentUser = ((List)userListResult.getData()).stream().filter(u -> u.getId().equals(AuthUtil.getUserId())).findAny();
                Assert.isTrue((boolean)agentUser.isPresent(), (String)"\u5f53\u524d\u767b\u9646\u4eba\u6ca1\u6709\u8d4b\u4e88\u7ad9\u957f\u89d2\u8272\uff0c\u65e0\u6cd5\u5904\u7406");
            }
        } else if (Constants.REVIEW_FINISH_STATUS == entity.getStatus() || Constants.REVIEW_NOT_PASS_STATUS == entity.getStatus()) {
            entity.setReviewer(AuthUtil.getUserId());
            entity.setReviewTime(LocalDateTime.now());
            R userListResult = this.userClient.relationUserListByRoleAlias(AuthUtil.getTenantId(), req.getCreateDept(), "safetyReviewer");
            if (userListResult.isSuccess()) {
                Optional<User> agentUser = ((List)userListResult.getData()).stream().filter(u -> u.getId().equals(AuthUtil.getUserId())).findAny();
                Assert.isTrue((boolean)agentUser.isPresent(), (String)"\u5f53\u524d\u767b\u9646\u4eba\u6ca1\u6709\u8d4b\u4e88\u5b89\u5168\u8bc4\u5ba1\u89d2\u8272\uff0c\u65e0\u6cd5\u5904\u7406");
            }
        } else if (CollectionUtil.isNotEmpty((Collection)req.getReviewStandardEntityList())) {
            this.reviewStandardService.saveOrUpdateBatch((Collection)req.getReviewStandardEntityList());
        }
        return R.status((boolean)this.reviewService.updateById((Object)entity));
    }

    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5")
    @ApiOperationSupport(order=3)
    public R<ReviewVo> detail(@PathVariable @ApiParam(value="\u5220\u9664id\uff0c\u6309\u9017\u53f7\u5206\u9694") String id) {
        ReviewEntity reviewEntity = (ReviewEntity)this.reviewService.getById((Serializable)((Object)id));
        ReviewVo vo = ReviewWrapper.build().entityVO(reviewEntity);
        List standardEntityList = this.reviewStandardService.list((Wrapper)Wrappers.lambdaQuery().eq(ReviewStandardEntity::getReviewId, (Object)id));
        vo.setReviewStandardEntityList(standardEntityList);
        return R.data((Object)vo);
    }

    @GetMapping(value={"/listPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @ApiOperationSupport(order=4)
    public R<IPage> listPage(ReviewDto req, Query query) {
        LambdaQueryWrapper queryWrapper = Condition.getQueryWrapper((Object)new ReviewEntity(), (Object)BeanUtil.copy((Object)req, ReviewEntity.class));
        if (Func.isNotEmpty((Object)req.getStatus())) {
            queryWrapper.eq(BaseEntity::getStatus, (Object)req.getStatus());
        }
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        queryWrapper.orderByDesc(BaseEntity::getUpdateTime);
        IPage page = this.reviewService.page(Condition.getPage((Query)query), (Wrapper)queryWrapper);
        page.setRecords(ReviewWrapper.build().listVO(page.getRecords()));
        return R.data((Object)page);
    }

    @DeleteMapping(value={"/remove/{ids}"})
    @ApiOperation(value="\u5220\u9664")
    @ApiOperationSupport(order=5)
    @Transactional(rollbackFor={Exception.class})
    public R<Boolean> removeByIds(@PathVariable String ids) {
        Arrays.stream(ids.split(",")).forEach(id -> {
            this.reviewStandardService.remove((Wrapper)Wrappers.lambdaQuery().eq(ReviewStandardEntity::getReviewId, id));
            this.reviewService.removeById((Serializable)((Object)id));
        });
        return R.status((boolean)true);
    }

    public ReviewController(IReviewService reviewService, IUserClient userClient, IReviewStandardService reviewStandardService) {
        this.reviewService = reviewService;
        this.userClient = userClient;
        this.reviewStandardService = reviewStandardService;
    }
}

