/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.excel;

import com.hnac.hzims.safeproduct.dto.DangerSourceDTO;
import com.hnac.hzims.safeproduct.enums.DangerSourceLevelEnum;
import com.hnac.hzims.safeproduct.excel.DangerSourceSaveExcel;
import com.hnac.hzims.safeproduct.service.IDangerSourceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springblade.core.excel.support.ExcelImporter;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.StringUtil;

public class DangerSourceImporter
implements ExcelImporter<DangerSourceSaveExcel> {
    private final IDangerSourceService service;
    public int counter = 2;

    public DangerSourceImporter(IDangerSourceService service) {
        this.service = service;
    }

    private List<String> validate(DangerSourceSaveExcel req) {
        ArrayList<String> errors = new ArrayList<String>(10);
        if (null == req.getTypeName()) {
            errors.add("\u5371\u9669\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == req.getEquName()) {
            errors.add("\u8bbe\u5907\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((CharSequence)req.getName())) {
            errors.add("\u5371\u9669\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((CharSequence)req.getDangerEle())) {
            errors.add("\u5371\u9669\u56e0\u7d20\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((CharSequence)req.getCause())) {
            errors.add("\u53ef\u80fd\u5bfc\u81f4\u7684\u4e8b\u6545\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((CharSequence)req.getLevelName())) {
            errors.add("\u98ce\u9669\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            req.setLevel(DangerSourceLevelEnum.getValue((String)req.getLevelName()));
        }
        if (StringUtil.isBlank((CharSequence)req.getMeasures())) {
            errors.add("\u63aa\u65bd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return errors;
    }

    public void save(List<DangerSourceSaveExcel> data) {
        data.forEach(item -> {
            List errors = this.validate(item);
            if (CollectionUtil.isNotEmpty((Collection)errors)) {
                String msg = errors.stream().collect(Collectors.joining("\r\n"));
                throw new RuntimeException(msg);
            }
            DangerSourceDTO req = (DangerSourceDTO)BeanUtil.copy((Object)item, DangerSourceDTO.class);
            req.setCreateUser(Long.valueOf(-1L));
            this.service.doSave(req);
            ++this.counter;
        });
    }
}

