/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.excel;

import com.hnac.hzims.safeproduct.dto.SafetyToolDTO;
import com.hnac.hzims.safeproduct.excel.SafetyToolSaveExcel;
import com.hnac.hzims.safeproduct.service.ISafetyToolService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springblade.core.excel.support.ExcelImporter;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.StringUtil;

public class SafetyToolImporter
implements ExcelImporter<SafetyToolSaveExcel> {
    private final ISafetyToolService service;
    public int counter = 2;
    private Map<String, String> typeNames;

    public SafetyToolImporter(ISafetyToolService service, Map<String, String> typeNames) {
        this.service = service;
        this.typeNames = typeNames;
    }

    private List<String> validate(SafetyToolSaveExcel req) {
        ArrayList<String> errors = new ArrayList<String>(10);
        if (StringUtil.isBlank((CharSequence)req.getToolCode())) {
            errors.add("\u5de5\u5668\u5177\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isBlank((CharSequence)req.getToolName())) {
            errors.add("\u5de5\u5668\u5177\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (!this.typeNames.containsKey(req.getTypeName())) {
            errors.add("\u586b\u5199\u7684\u5de5\u5668\u5177\u7c7b\u578b\u4e0d\u5b58\u5728");
        } else {
            Long typeId = Long.valueOf((String)this.typeNames.get(req.getTypeName()));
            req.setTypeId(typeId);
        }
        if (StringUtil.isBlank((CharSequence)req.getTypeName())) {
            errors.add("\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == req.getSafeTime()) {
            errors.add("\u6709\u6548\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (req.getSafeTime() < 1) {
            errors.add("\u6709\u6548\u671f\u9650\u5fc5\u987b\u4e3a\u6b63\u6574\u6570");
        }
        return errors;
    }

    public void save(List<SafetyToolSaveExcel> data) {
        data.forEach(item -> {
            List errors = this.validate(item);
            if (CollectionUtil.isNotEmpty((Collection)errors)) {
                String msg = errors.stream().collect(Collectors.joining("\r\n"));
                throw new RuntimeException(msg);
            }
            SafetyToolDTO req = (SafetyToolDTO)BeanUtil.copy((Object)item, SafetyToolDTO.class);
            req.setCreateUser(Long.valueOf(-1L));
            this.service.save((Object)req);
            ++this.counter;
        });
    }
}

