/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.feign;

import com.hnac.hzims.safeproduct.entity.DangerSourceEntity;
import com.hnac.hzims.safeproduct.feign.IDangerSourceClient;
import com.hnac.hzims.safeproduct.service.IDangerSourceService;
import com.hnac.hzims.safeproduct.vo.SourceVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.springblade.system.vo.CreateTableVO;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DangerSourceClient
implements IDangerSourceClient {
    private final IDangerSourceService service;

    @GetMapping(value={"/feign/dangerSource/details"})
    public List<DangerSourceEntity> details(@RequestParam String[] ids) {
        List<DangerSourceEntity> resp = this.service.listByIds(Arrays.asList(ids));
        if (CollectionUtils.isEmpty((Collection)resp)) {
            return new ArrayList<DangerSourceEntity>();
        }
        Map<String, Integer> sortCondition = Arrays.stream(ids).collect(Collectors.toMap(o -> o, o -> ArrayUtils.lastIndexOf((Object[])ids, (Object)o)));
        resp = resp.stream().sorted((o1, o2) -> (Integer)sortCondition.get(o2.getId().toString()) - (Integer)sortCondition.get(o1.getId().toString())).collect(Collectors.toList());
        return resp;
    }

    @GetMapping(value={"/feign/dangerSource/listByTenantId"})
    public List<SourceVO> listByTenantId(String tenantId) {
        return this.service.listByTenantId(tenantId);
    }

    @PostMapping(value={"/feign/dangerSource/getSafeCreateTable"})
    public List<CreateTableVO> getSafeCreateTable(List<String> tableNames) {
        return this.service.getSafeCreateTable(tableNames);
    }

    public DangerSourceClient(IDangerSourceService service) {
        this.service = service;
    }
}

