/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.scheduled;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hnac.hzims.message.entity.config.PushConfigEntity;
import com.hnac.hzims.message.entity.config.SmsConfigEntity;
import com.hnac.hzims.message.fegin.IMessageConfigClient;
import com.hnac.hzims.message.fegin.IMessageSmsClient;
import com.hnac.hzims.safeproduct.entity.SafetyToolEntity;
import com.hnac.hzims.safeproduct.entity.SafetyToolTypeEntity;
import com.hnac.hzims.safeproduct.service.ISafetyToolService;
import com.hnac.hzims.safeproduct.service.ISafetyToolTypeService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springblade.system.user.cache.UserCache;
import org.springblade.system.user.entity.User;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SafeToolTypePushUserTask {
    private static final Logger log = LoggerFactory.getLogger(SafeToolTypePushUserTask.class);
    private final IMessageSmsClient messageSmsClient;
    private final ISafetyToolTypeService toolTypeService;
    private final ISafetyToolService safetyToolService;
    private final IMessageConfigClient messageConfigClient;
    public static final int APP_PUSH = 1;
    public static final int JG_PUSH = 2;
    @Value(value="${hzims.safeProduct.safeTool.sadeToolKey}")
    private String sadeToolKey;
    @Value(value="${hzims.jgPushCode}")
    private String jgPushCode;
    @Value(value="${hzims.tenantId}")
    private String tenantId;
    @Value(value="${hzims.safeProduct.safeTool.sms-code}")
    private String smsCode;

    @XxlJob(value="safeToolTypePushUserHandler")
    public ReturnT<String> execute(String params) throws Exception {
        LocalDate now = LocalDate.now();
        LocalDateTime today_start = LocalDateTime.of(now.plusDays(1L), LocalTime.MIN);
        LocalDateTime today_end = LocalDateTime.of(now.plusDays(1L), LocalTime.MAX);
        List toolEntityList = this.safetyToolService.list((Wrapper)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList EntityList = new ArrayList();
        toolEntityList.stream().filter(safetyToolEntity -> Func.isNotEmpty((Object)safetyToolEntity.getNoticeUsers())).forEach(safetyToolEntity -> {
            SafetyToolEntity newToolEntity = (SafetyToolEntity)BeanUtil.copy((Object)safetyToolEntity, SafetyToolEntity.class);
            List<String> noticeUserList = Arrays.asList(safetyToolEntity.getNoticeUsers().split(","));
            noticeUserList.forEach(userId -> {
                newToolEntity.setNoticeUsers(userId);
                EntityList.add(newToolEntity);
            });
        });
        Map<String, Map<Integer, List<SafetyToolEntity>>> groupMap = EntityList.stream().collect(Collectors.groupingBy(SafetyToolEntity::getNoticeUsers, Collectors.groupingBy(SafetyToolEntity::getSendType)));
        groupMap.forEach((userId, sendTypeMap) -> {
            User noticeUser = UserCache.getUser((Long)Long.parseLong(userId));
            if (ObjectUtil.isEmpty((Object)noticeUser)) {
                return;
            }
            sendTypeMap.forEach((sendType, list) -> {
                List typeIdList = list.stream().map(SafetyToolEntity::getTypeId).collect(Collectors.toList());
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.select(new String[]{"DISTINCT TYPE_NAME"}).in((Object)"id", typeIdList);
                List typeEntityList = this.toolTypeService.list((Wrapper)queryWrapper);
                if (CollectionUtil.isEmpty((Collection)typeEntityList)) {
                    return;
                }
                String typeNames = typeEntityList.size() > 2 ? typeEntityList.subList(0, 2).stream().map(SafetyToolTypeEntity::getTypeName).collect(Collectors.joining("\u3001")).concat("\u7b49") : typeEntityList.stream().map(SafetyToolTypeEntity::getTypeName).collect(Collectors.joining("\u3001"));
                XxlJobLogger.log((String)"\u5f00\u59cb\u63a8\u9001\uff0c\u63a8\u9001\u4eba\uff1a{}", (Object[])new Object[]{JSONObject.toJSONString((Object)noticeUser.getName())});
                if (sendType == 1 && Func.isNotEmpty((Object)noticeUser.getPhone())) {
                    String code = "safeTool";
                    SmsConfigEntity smsConfigEntity = this.messageConfigClient.getSmsConfigByBusinessKey(code);
                    HashMap<String, String> contentParams = new HashMap<String, String>(2);
                    contentParams.put("one", typeNames);
                    contentParams.put("two", DateUtil.format((TemporalAccessor)now.plusDays(1L), (String)"yyyy-MM-dd"));
                    smsConfigEntity.setTemplateParam(JSONObject.toJSONString(contentParams));
                    smsConfigEntity.setPhones(noticeUser.getPhone());
                    this.messageConfigClient.pushSmsMessageByConfig(smsConfigEntity);
                }
                if (sendType == 2) {
                    PushConfigEntity pushConfigEntity = this.messageConfigClient.getAppConfigByBusinessKey("safeTool");
                    pushConfigEntity.setPushers(noticeUser.getId().toString());
                    pushConfigEntity.setContent(String.format(pushConfigEntity.getContent(), typeNames, DateUtil.format((TemporalAccessor)now.plusDays(1L), (String)"yyyy-MM-dd")));
                    this.messageConfigClient.pushAppMessageByConfig(pushConfigEntity);
                }
            });
        });
        return new ReturnT((Object)"SUCCESS");
    }

    public SafeToolTypePushUserTask(IMessageSmsClient messageSmsClient, ISafetyToolTypeService toolTypeService, ISafetyToolService safetyToolService, IMessageConfigClient messageConfigClient) {
        this.messageSmsClient = messageSmsClient;
        this.toolTypeService = toolTypeService;
        this.safetyToolService = safetyToolService;
        this.messageConfigClient = messageConfigClient;
    }
}

