/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.scheduled;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hnac.hzims.safeproduct.enums.MsgSendTypeEnum;
import com.hnac.hzims.safeproduct.mapper.SafetyToolTypeMapper;
import com.hnac.hzims.safeproduct.mapper.SafetyToolTypeUserMapper;
import com.hnac.hzims.safeproduct.scheduled.SafetyToolRecheckBeforeTask;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.resource.feign.ISmsClient;
import org.springblade.system.user.entity.User;
import org.springblade.system.user.feign.IUserClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SafetyToolRecheckBeforeTask {
    private static final Logger log = LoggerFactory.getLogger(SafetyToolRecheckBeforeTask.class);
    @Autowired
    private ISmsClient smsClient;
    @Autowired
    private IUserClient userClient;
    @Autowired
    private SafetyToolTypeMapper safetyToolTypeMapper;
    @Autowired
    private SafetyToolTypeUserMapper safetyToolTypeUserMapper;

    @XxlJob(value="safeToolRecheckBeforeHandler")
    public ReturnT<String> execute(String param) throws Exception {
        log.info("safeToolRecheckBeforeHandler start ...");
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"status", (Object)1);
        List list = this.safetyToolTypeMapper.selectList((Wrapper)qw);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(safetyToolType -> {
                log.info(String.format("\u904d\u5386\u5230\u5de5\u5668\u5177\u7c7b\u578b\uff1a%s  %s", safetyToolType.getId(), safetyToolType.getTypeName()));
                log.info(DateUtil.formatDate((Date)safetyToolType.getSendTime()));
                log.info(DateUtil.formatDate((Date)DateUtil.now()));
                if (DateUtil.formatDate((Date)safetyToolType.getSendTime()).equals(DateUtil.formatDate((Date)DateUtil.now()))) {
                    log.info(String.format("\u5f00\u59cb\u5904\u7406\u5de5\u5668\u5177\u7c7b\u578b\uff1a%s  %s", safetyToolType.getId(), safetyToolType.getTypeName()));
                    List users = this.safetyToolTypeUserMapper.selectListByTypeId(safetyToolType.getId());
                    if (CollectionUtils.isEmpty((Collection)users)) {
                        return;
                    }
                    log.info(String.format("\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f\uff1a%s", JSONObject.toJSONString((Object)users)));
                    String phones = users.stream().map(o -> {
                        R userR = this.userClient.userInfoById(o.getUserId());
                        log.info(JSONObject.toJSONString((Object)userR));
                        return userR == null || userR.getData() == null || StringUtils.isBlank((String)((User)userR.getData()).getPhone()) ? "" : ((User)userR.getData()).getPhone();
                    }).filter(o -> StringUtils.isNotBlank((String)o)).collect(Collectors.joining(","));
                    if (StringUtils.isBlank((String)phones)) {
                        return;
                    }
                    log.info(String.format("\u67e5\u8be2\u5230\u8d26\u6237phones\uff1a%s", phones));
                    if (MsgSendTypeEnum.SMS.getValue() == safetyToolType.getSendType().intValue()) {
                        1 resp = new /* Unavailable Anonymous Inner Class!! */;
                        R r = this.smsClient.sendMessage(safetyToolType.getTenantId(), "safetool-recheck-before", JSONObject.toJSONString((Object)resp), phones);
                    }
                }
            });
        }
        log.info("safeToolRecheckBeforeHandler end ...");
        return new ReturnT((Object)"SUCCESS");
    }
}

