/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hnac.hzims.safeproduct.dto.CheckCompanyDTO;
import com.hnac.hzims.safeproduct.entity.CheckCompanyEntity;
import com.hnac.hzims.safeproduct.entity.CheckItemEntity;
import com.hnac.hzims.safeproduct.entity.CheckItemInstanceEntity;
import com.hnac.hzims.safeproduct.mapper.CheckCompanyMapper;
import com.hnac.hzims.safeproduct.service.ICheckCompanyService;
import com.hnac.hzims.safeproduct.service.ICheckItemInstanceService;
import com.hnac.hzims.safeproduct.service.impl.CheckCompanyServiceImpl;
import com.hnac.hzims.safeproduct.vo.CheckCompanyVo;
import com.hnac.hzims.safeproduct.wrapper.CheckCompanyWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.base.BaseServiceImpl;
import org.springblade.core.mp.support.Condition;
import org.springblade.core.mp.support.Query;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.Func;
import org.springblade.system.entity.Dept;
import org.springblade.system.feign.ISysClient;
import org.springframework.stereotype.Service;

@Service
public class CheckCompanyServiceImpl
extends BaseServiceImpl<CheckCompanyMapper, CheckCompanyEntity>
implements ICheckCompanyService {
    private static final Logger log = LoggerFactory.getLogger(CheckCompanyServiceImpl.class);
    private final CheckCompanyMapper CheckCompanyMapper;
    private final ICheckItemInstanceService itemInstanceService;
    private final ISysClient sysClient;

    public boolean doSave(CheckCompanyDTO req) {
        boolean result = this.save((BaseEntity)req);
        if (result) {
            Long checkId = req.getId();
            List items = req.getItems();
            items.forEach(item -> {
                item.setOid(item.getId());
                item.setId(null);
                item.setCheckId(checkId);
            });
            this.itemInstanceService.saveBatch((Collection)items);
        }
        return result;
    }

    public boolean doUpdate(CheckCompanyDTO req) {
        boolean result = this.updateById((BaseEntity)req);
        if (result) {
            List items = req.getItems();
            items.forEach(arg_0 -> ((ICheckItemInstanceService)this.itemInstanceService).updateById(arg_0));
        }
        return result;
    }

    public R<CheckCompanyVo> detail(Long id) {
        CheckCompanyEntity entity = (CheckCompanyEntity)this.CheckCompanyMapper.selectById((Serializable)id);
        CheckCompanyVo vo = CheckCompanyWrapper.build().entityVO(entity);
        QueryWrapper queryMapper = new QueryWrapper();
        queryMapper.eq((Object)"CHECK_ID", (Object)vo.getId());
        queryMapper.orderByAsc((Object[])new String[]{"ORG_ID", "SORT"});
        List items = this.itemInstanceService.list((Wrapper)queryMapper);
        items.forEach(item -> item.setChildren(this.findChildren(item, items)));
        ArrayList list = new ArrayList();
        Map<Long, List<CheckItemInstanceEntity>> map = items.stream().collect(Collectors.groupingBy(CheckItemInstanceEntity::getOrgId));
        for (Map.Entry<Long, List<CheckItemInstanceEntity>> entry : map.entrySet()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("deptId", entry.getKey());
            R deptR = this.sysClient.getDept(entry.getKey());
            if (deptR.isSuccess()) {
                data.put("deptName", Optional.ofNullable(deptR.getData()).map(Dept::getDeptName).orElse(null));
            } else {
                data.put("deptName", null);
            }
            data.put("items", entry.getValue());
            list.add(data);
        }
        vo.setItems(list);
        return R.data((Object)vo);
    }

    private List<CheckItemEntity> findChildren(CheckItemInstanceEntity entity, List<CheckItemInstanceEntity> list) {
        ArrayList<CheckItemEntity> child = new ArrayList<CheckItemEntity>();
        for (CheckItemInstanceEntity itemEntity : list) {
            if (null == itemEntity.getParentItem() || !itemEntity.getParentItem().equals(entity.getOid()) || !itemEntity.getOrgId().equals(entity.getOrgId())) continue;
            child.add((CheckItemEntity)itemEntity);
            itemEntity.setChildren(this.findChildren(itemEntity, list));
        }
        return child;
    }

    public boolean doDelete(String ids) {
        List list = Func.toLongList((String)ids);
        boolean result = this.deleteLogic(list);
        if (result) {
            list.forEach(id -> {
                QueryWrapper queryMapper = new QueryWrapper();
                queryMapper.eq((Object)"CHECK_ID", id);
                this.itemInstanceService.remove((Wrapper)queryMapper);
            });
        }
        return result;
    }

    public R<IPage<CheckCompanyVo>> pageCondition(CheckCompanyEntity req, Query query) {
        1 queryWrapper = new /* Unavailable Anonymous Inner Class!! */;
        IPage page = this.page(Condition.getPage((Query)query), (Wrapper)queryWrapper);
        page.setRecords(CheckCompanyWrapper.build().listVO(page.getRecords()));
        return R.data((Object)page);
    }

    public CheckCompanyServiceImpl(CheckCompanyMapper CheckCompanyMapper2, ICheckItemInstanceService itemInstanceService, ISysClient sysClient) {
        this.CheckCompanyMapper = CheckCompanyMapper2;
        this.itemInstanceService = itemInstanceService;
        this.sysClient = sysClient;
    }
}

