/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hnac.hzims.operational.duty.dto.ChangeShiftsReqDTO;
import com.hnac.hzims.operational.duty.dto.ChangeShiftsRspDTO;
import com.hnac.hzims.operational.duty.feign.IDutyRecClient;
import com.hnac.hzims.operational.feign.IOperTaskClient;
import com.hnac.hzims.safeproduct.dto.CheckItemDTO;
import com.hnac.hzims.safeproduct.dto.CheckQueryItemDTO;
import com.hnac.hzims.safeproduct.dto.SafeEquipmentTrialDTO;
import com.hnac.hzims.safeproduct.entity.CheckItemEntity;
import com.hnac.hzims.safeproduct.entity.CheckItemInstanceEntity;
import com.hnac.hzims.safeproduct.entity.CheckQuarterEntity;
import com.hnac.hzims.safeproduct.enums.CheckItemEnum;
import com.hnac.hzims.safeproduct.mapper.CheckItemInstanceMapper;
import com.hnac.hzims.safeproduct.mapper.CheckItemMapper;
import com.hnac.hzims.safeproduct.service.ICheckItemService;
import com.hnac.hzims.safeproduct.service.ICheckQuarterService;
import com.hnac.hzims.safeproduct.service.SafeEquipmentTrialService;
import com.hnac.hzims.safeproduct.service.impl.CheckItemServiceImpl;
import com.hnac.hzims.safeproduct.vo.CheckItemVo;
import com.hnac.hzims.safeproduct.wrapper.CheckItemWrapper;
import com.hnac.hzims.ticket.workTicket.feign.IOperateTicketClient;
import com.hnac.hzims.ticket.workTicket.feign.ITicketInfoClient;
import com.hnac.hzims.vo.SafeCheckStatisticVO;
import com.hnac.hzinfo.inspect.task.feign.IInspectTaskClient;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.log.exception.ServiceException;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.base.BaseServiceImpl;
import org.springblade.core.mp.support.Condition;
import org.springblade.core.mp.support.Query;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springblade.system.entity.Dept;
import org.springblade.system.feign.ISysClient;
import org.springblade.system.user.cache.UserCache;
import org.springblade.system.user.entity.User;
import org.springframework.stereotype.Service;

@Service
public class CheckItemServiceImpl
extends BaseServiceImpl<CheckItemMapper, CheckItemEntity>
implements ICheckItemService {
    private static final Logger log = LoggerFactory.getLogger(CheckItemServiceImpl.class);
    private final CheckItemMapper checkItemMapper;
    private final CheckItemInstanceMapper checkItemInstanceMapper;
    private final IDutyRecClient dutyRecClient;
    private final SafeEquipmentTrialService safeEquipmentTrialService;
    private final IOperateTicketClient operateTicketClient;
    private final ITicketInfoClient ticketInfoClient;
    private final IInspectTaskClient inspectTaskClient;
    private final IOperTaskClient operTaskClient;
    private final ICheckQuarterService checkQuarterService;
    private final ISysClient sysClient;
    private final ExecutorService executor = Executors.newFixedThreadPool(10);
    private final DateTimeFormatter monthFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public boolean doSave(CheckItemDTO req) {
        List list = this.list((Wrapper)new /* Unavailable Anonymous Inner Class!! */);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            throw new ServiceException("\u68c0\u67e5\u9879\u540d\u79f0\u6216\u5e8f\u53f7\u5df2\u5b58\u5728");
        }
        boolean result = this.save((BaseEntity)req);
        if (result) {
            this.updateParentScore((CheckItemEntity)req, false);
        }
        return result;
    }

    public boolean doUpdate(CheckItemDTO req) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.ne(BaseEntity::getId, (Object)req.getId());
        lambdaQueryWrapper.and(q -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)q.eq(CheckItemEntity::getItem, (Object)req.getItem())).or()).eq(CheckItemEntity::getSort, (Object)req.getSort());
        });
        List list = this.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            throw new ServiceException("\u68c0\u67e5\u9879\u540d\u79f0\u6216\u5e8f\u53f7\u5df2\u5b58\u5728");
        }
        boolean result = this.updateById((BaseEntity)req);
        if (result) {
            this.updateParentScore((CheckItemEntity)req, false);
        }
        return result;
    }

    private void updateParentScore(CheckItemEntity entity, boolean isDelete) {
        Long parentId = entity.getParentItem();
        if (ObjectUtil.isNotEmpty((Object)parentId)) {
            QueryWrapper entityQueryWrapper = new QueryWrapper();
            entityQueryWrapper.eq((Object)"PARENT_ITEM", (Object)parentId);
            entityQueryWrapper.ne((Object)"ID", (Object)entity.getId());
            List children = this.list((Wrapper)entityQueryWrapper);
            if (!isDelete) {
                children.add(entity);
            }
            double parentTotal = children.stream().map(CheckItemEntity::getTotalScore).mapToDouble(Double::doubleValue).sum();
            CheckItemEntity parentItem = (CheckItemEntity)this.getById((Serializable)parentId);
            parentItem.setTotalScore(Double.valueOf(parentTotal));
            this.updateById((BaseEntity)parentItem);
            if (ObjectUtil.isNotEmpty((Object)parentItem.getParentItem())) {
                this.updateParentScore(parentItem, false);
            }
        }
    }

    public R<CheckItemVo> detail(Long id) {
        CheckItemEntity entity = (CheckItemEntity)this.checkItemMapper.selectById((Serializable)id);
        CheckItemVo vo = CheckItemWrapper.build().entityVO(entity);
        return R.data((Object)vo);
    }

    public boolean remove(String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        list.forEach(id -> {
            CheckItemEntity entity = (CheckItemEntity)this.getById((Serializable)((Object)id));
            this.updateParentScore(entity, true);
        });
        return this.deleteLogic(Func.toLongList((String)ids));
    }

    public R<List<Map<String, Object>>> getCompanyCheckItems(CheckQueryItemDTO req) throws Exception {
        String[] deptIds;
        ArrayList list = new ArrayList();
        if (StringUtils.isEmpty((String)req.getDeptIds())) {
            return R.fail((String)"\u8bf7\u4f20\u5165\u673a\u6784ID");
        }
        for (String deptId : deptIds = req.getDeptIds().split(",")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("deptId", deptId);
            R deptR = this.sysClient.getDept(Long.valueOf(Long.parseLong(deptId)));
            if (deptR.isSuccess()) {
                map.put("deptName", Optional.ofNullable(deptR.getData()).map(Dept::getDeptName).orElse(null));
            } else {
                map.put("deptName", null);
            }
            req.setDeptId(Long.valueOf(Long.parseLong(deptId)));
            R items = this.getItems(req);
            map.put("items", items.getData());
            list.add(map);
        }
        return R.data(list);
    }

    public R<List<CheckItemInstanceEntity>> getItems(CheckQueryItemDTO req) throws Exception {
        2 queryWrapper = new /* Unavailable Anonymous Inner Class!! */;
        List list = this.list((Wrapper)queryWrapper);
        list.forEach(entity -> entity.setChildren(this.findChildren(entity, list)));
        List checkItemInstanceEntities = list.stream().map(entity -> (CheckItemInstanceEntity)BeanUtil.copy((Object)entity, CheckItemInstanceEntity.class)).collect(Collectors.toList());
        this.getSystemSituation(checkItemInstanceEntities, req);
        if (req.isQuarterCheck()) {
            this.jointItemInstance(req, checkItemInstanceEntities);
        }
        return R.data(checkItemInstanceEntities);
    }

    private void jointItemInstance(CheckQueryItemDTO req, List<CheckItemInstanceEntity> checkItemInstanceEntities) {
        List months = this.getMonthByQuarter(req);
        List allMonthCheckItemInstance = this.checkItemInstanceMapper.getCheckItemInstanceByMonth(months, Long.valueOf(Long.parseLong(AuthUtil.getDeptId())));
        for (CheckItemInstanceEntity entity : checkItemInstanceEntities) {
            for (CheckItemInstanceEntity monthItem : allMonthCheckItemInstance) {
                if (!entity.getItem().equals(monthItem.getItem()) || !monthItem.getSystemSituation().startsWith("https://")) continue;
                StringBuilder stringBuilder = new StringBuilder();
                if (StringUtils.isEmpty((String)entity.getSystemSituation())) {
                    stringBuilder.append(monthItem.getSystemSituation());
                } else {
                    stringBuilder.append(entity.getSystemSituation()).append(",").append(monthItem.getSystemSituation());
                }
                entity.setSystemSituation(stringBuilder.toString());
            }
        }
    }

    public R<IPage<CheckItemVo>> pageCondition(CheckItemDTO req, Query query) {
        3 queryWrapper = new /* Unavailable Anonymous Inner Class!! */;
        IPage page = super.page(Condition.getPage((Query)query), (Wrapper)queryWrapper);
        page.setRecords(CheckItemWrapper.build().listVO(page.getRecords()));
        return R.data((Object)page);
    }

    private void getSystemSituation(List<CheckItemInstanceEntity> list, CheckQueryItemDTO req) throws Exception {
        String startTime = req.getStartTime();
        String endTime = req.getEndTime();
        Long deptId = ObjectUtil.isNotEmpty((Object)req.getDeptId()) ? req.getDeptId() : Long.parseLong(AuthUtil.getDeptId());
        log.info("\u5b89\u5168\u68c0\u67e5\u7edf\u8ba1\u6570\u636e\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a{}\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff0c\u90e8\u95e8ID\uff1a{}", new Object[]{startTime, endTime, deptId});
        CompletableFuture<SafeCheckStatisticVO> workFuture = CompletableFuture.supplyAsync(() -> {
            SafeCheckStatisticVO vo = new SafeCheckStatisticVO();
            R resp = this.ticketInfoClient.getWorkTicketCheck(startTime, endTime, deptId);
            if (resp.isSuccess()) {
                vo = (SafeCheckStatisticVO)resp.getData();
            } else {
                log.error("\u67e5\u8be2\u5de5\u4f5c\u7968\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff01");
            }
            return vo;
        }, this.executor);
        CompletableFuture<SafeCheckStatisticVO> operationFuture = CompletableFuture.supplyAsync(() -> {
            SafeCheckStatisticVO vo = new SafeCheckStatisticVO();
            R resp = this.operateTicketClient.getOperateTicketCheck(startTime, endTime, deptId);
            if (resp.isSuccess()) {
                vo = (SafeCheckStatisticVO)resp.getData();
            } else {
                log.error("\u67e5\u8be2\u64cd\u4f5c\u7968\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff01");
            }
            return vo;
        }, this.executor);
        CompletableFuture<ChangeShiftsRspDTO> changeShiftsFuture = CompletableFuture.supplyAsync(() -> {
            ChangeShiftsReqDTO reqDTO = new ChangeShiftsReqDTO();
            reqDTO.setStartTime(startTime);
            reqDTO.setEndTime(endTime);
            reqDTO.setCreateDept(deptId);
            R resp = this.dutyRecClient.getChangeShifts(reqDTO);
            ChangeShiftsRspDTO rspDTO = new ChangeShiftsRspDTO();
            if (resp.isSuccess()) {
                rspDTO = (ChangeShiftsRspDTO)resp.getData();
            } else {
                log.error("\u67e5\u8be2\u4ea4\u63a5\u73ed\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff01");
            }
            return rspDTO;
        }, this.executor);
        CompletableFuture<Integer> testCountFuture = CompletableFuture.supplyAsync(() -> {
            SafeEquipmentTrialDTO reqDTO = new SafeEquipmentTrialDTO();
            reqDTO.setStartTime(startTime);
            reqDTO.setEndTime(endTime);
            LinkedList<Long> deptList = new LinkedList<Long>();
            deptList.add(deptId);
            reqDTO.setDeptList(deptList);
            int count = this.safeEquipmentTrialService.getSafeEquipmentCount(reqDTO);
            return count;
        }, this.executor);
        CompletableFuture<SafeCheckStatisticVO> staffFuture = CompletableFuture.supplyAsync(() -> {
            SafeCheckStatisticVO vo = new SafeCheckStatisticVO();
            R resp = this.inspectTaskClient.getInspectTaskCheck(startTime, endTime, deptId, "1");
            if (resp.isSuccess()) {
                vo = (SafeCheckStatisticVO)resp.getData();
            } else {
                log.error("\u67e5\u8be2\u8fd0\u884c\u4eba\u5458\u5de1\u56de\u68c0\u67e5\u626b\u7801\u6570\u636e\u5931\u8d25\uff01");
            }
            return vo;
        }, this.executor);
        CompletableFuture<SafeCheckStatisticVO> managerFuture = CompletableFuture.supplyAsync(() -> {
            SafeCheckStatisticVO vo = new SafeCheckStatisticVO();
            R resp = this.inspectTaskClient.getInspectTaskCheck(startTime, endTime, deptId, "2");
            if (resp.isSuccess()) {
                vo = (SafeCheckStatisticVO)resp.getData();
            } else {
                log.error("\u67e5\u8be2\u7ba1\u7406\u53ca\u5176\u4ed6\u4eba\u5458\u5de1\u56de\u68c0\u67e5\u626b\u7801\u6570\u636e\u5931\u8d25\uff01");
            }
            return vo;
        }, this.executor);
        CompletableFuture<List> finalStatisticVOListFuture = CompletableFuture.supplyAsync(() -> {
            List result = new ArrayList();
            R response = this.operTaskClient.getOperationalTask(startTime, endTime, deptId);
            if (response.isSuccess()) {
                result = (List)response.getData();
            } else {
                log.error("\u67e5\u8be2\u6d88\u7f3a\u4e0e\u65e5\u5e38\u7ef4\u62a4\u7edf\u8ba1\u6570\u636e\u5931\u8d25\uff01");
            }
            return result;
        }, this.executor);
        CompletableFuture.allOf(workFuture, operationFuture, changeShiftsFuture, testCountFuture, staffFuture, managerFuture, finalStatisticVOListFuture).join();
        SafeCheckStatisticVO workTicketVo = workFuture.get();
        SafeCheckStatisticVO operationTicketVo = operationFuture.get();
        ChangeShiftsRspDTO changeShiftsRspDTO = changeShiftsFuture.get();
        Integer testCount = testCountFuture.get();
        SafeCheckStatisticVO staffVo = staffFuture.get();
        SafeCheckStatisticVO managerVo = managerFuture.get();
        List finalStatisticVOList = finalStatisticVOListFuture.get();
        this.setFieldValueNotNull((Object)workTicketVo);
        this.setFieldValueNotNull((Object)operationTicketVo);
        this.setFieldValueNotNull((Object)changeShiftsRspDTO);
        this.setFieldValueNotNull((Object)staffVo);
        this.setFieldValueNotNull((Object)managerVo);
        for (SafeCheckStatisticVO safeCheckStatisticVO : finalStatisticVOList) {
            this.setFieldValueNotNull((Object)safeCheckStatisticVO);
        }
        list.forEach(itemInstance -> {
            if (CheckItemEnum.WORK_TICKET.getName().equals(itemInstance.getItem())) {
                itemInstance.setSystemSituation(String.format(CheckItemEnum.WORK_TICKET.getValue(), workTicketVo.getTotal(), workTicketVo.getQualifiedRate()));
            }
            if (CheckItemEnum.OPERATION_TICKET.getName().equals(itemInstance.getItem())) {
                itemInstance.setSystemSituation(String.format(CheckItemEnum.OPERATION_TICKET.getValue(), operationTicketVo.getTotal(), operationTicketVo.getQualifiedRate()));
            }
            if (CheckItemEnum.SUCCESSION.getName().equals(itemInstance.getItem())) {
                itemInstance.setSystemSituation(String.format(CheckItemEnum.SUCCESSION.getValue(), changeShiftsRspDTO.getShiftsCount(), changeShiftsRspDTO.getShiftsRate()));
            }
            if (CheckItemEnum.REGULAR_TEST_CHECK.getName().equals(itemInstance.getItem())) {
                itemInstance.setSystemSituation(String.format(CheckItemEnum.REGULAR_TEST_CHECK.getValue(), testCount));
            }
            if (CheckItemEnum.STAFF_CIRCUIT.getName().equals(itemInstance.getItem())) {
                itemInstance.setSystemSituation(String.format(CheckItemEnum.STAFF_CIRCUIT.getValue(), staffVo.getTotal()));
            }
            if (CheckItemEnum.MANAGER_CIRCUIT.getName().equals(itemInstance.getItem())) {
                itemInstance.setSystemSituation(String.format(CheckItemEnum.MANAGER_CIRCUIT.getValue(), managerVo.getTotal()));
            }
            if (CheckItemEnum.QUARTER_CHECK.getName().equals(itemInstance.getItem())) {
                itemInstance.setSystemSituation(this.getQuarterCheck(req));
            }
            if (CheckItemEnum.MAJOR_DEFECTS.getName().equals(itemInstance.getItem())) {
                for (SafeCheckStatisticVO statisticVO : finalStatisticVOList) {
                    if (!CheckItemEnum.MAJOR_DEFECTS.getName().equals(statisticVO.getProjectTypeName())) continue;
                    itemInstance.setSystemSituation(String.format(CheckItemEnum.MAJOR_DEFECTS.getValue(), statisticVO.getTotal(), statisticVO.getQualifiedRate()));
                }
            }
            if (CheckItemEnum.GENERAL_DEFECTS.getName().equals(itemInstance.getItem())) {
                for (SafeCheckStatisticVO statisticVO : finalStatisticVOList) {
                    if (!CheckItemEnum.GENERAL_DEFECTS.getName().equals(statisticVO.getProjectTypeName())) continue;
                    itemInstance.setSystemSituation(String.format(CheckItemEnum.GENERAL_DEFECTS.getValue(), statisticVO.getTotal(), statisticVO.getQualifiedRate()));
                }
            }
            if (CheckItemEnum.REGULAR_MAINTAIN.getName().equals(itemInstance.getItem())) {
                for (SafeCheckStatisticVO statisticVO : finalStatisticVOList) {
                    if (!CheckItemEnum.REGULAR_MAINTAIN.getName().equals(statisticVO.getProjectTypeName())) continue;
                    itemInstance.setSystemSituation(String.format(CheckItemEnum.REGULAR_MAINTAIN.getValue(), statisticVO.getTotal()));
                }
            }
            if (CheckItemEnum.REGULAR_SERVICE.getName().equals(itemInstance.getItem())) {
                for (SafeCheckStatisticVO statisticVO : finalStatisticVOList) {
                    if (!CheckItemEnum.REGULAR_SERVICE.getName().equals(statisticVO.getProjectTypeName())) continue;
                    itemInstance.setSystemSituation(String.format(CheckItemEnum.REGULAR_SERVICE.getValue(), statisticVO.getTotal()));
                }
            }
        });
    }

    private String getQuarterCheck(CheckQueryItemDTO req) {
        if (req.isQuarterCheck()) {
            return "\u5426";
        }
        LocalDateTime localDateTime = LocalDateTime.parse(req.getStartTime(), this.dateTimeFormatter);
        int year = localDateTime.getYear();
        int month = localDateTime.getMonthValue();
        int quarter = month % 3 == 0 ? month / 3 : month / 3 + 1;
        List list = this.checkQuarterService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CheckQuarterEntity::getYear, (Object)year)).eq(CheckQuarterEntity::getQuarter, (Object)("0" + quarter)));
        return list.size() > 0 ? "\u662f" : "\u5426";
    }

    private List<String> getMonthByQuarter(CheckQueryItemDTO req) {
        Month month = Month.of(req.getQuarter() * 3);
        Month first = month.firstMonthOfQuarter();
        Month second = Month.of(first.getValue() + 1);
        Month third = Month.of(first.getValue() + 2);
        ArrayList<String> months = new ArrayList<String>();
        YearMonth yearMonth = YearMonth.of((int)req.getYear(), first);
        String firstMonth = yearMonth.format(this.monthFormatter);
        months.add(firstMonth);
        yearMonth = YearMonth.of((int)req.getYear(), second);
        String secondMonth = yearMonth.format(this.monthFormatter);
        months.add(secondMonth);
        yearMonth = YearMonth.of((int)req.getYear(), third);
        String thirdMonth = yearMonth.format(this.monthFormatter);
        months.add(thirdMonth);
        return months;
    }

    private void setFieldValueNotNull(Object obj) throws Exception {
        for (Field field : obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.get(obj) != null) continue;
            if ("class java.lang.String".equals(field.getGenericType().toString())) {
                field.set(obj, "");
                continue;
            }
            if ("class java.lang.Integer".equals(field.getGenericType().toString())) {
                field.set(obj, 0);
                continue;
            }
            if ("class java.lang.Double".equals(field.getGenericType().toString())) {
                field.set(obj, 0.0);
                continue;
            }
            if (!"class java.lang.Long".equals(field.getGenericType().toString())) continue;
            field.set(obj, 0L);
        }
    }

    private List<CheckItemEntity> findChildren(CheckItemEntity entity, List<CheckItemEntity> list) {
        ArrayList<CheckItemEntity> child = new ArrayList<CheckItemEntity>();
        for (CheckItemEntity itemEntity : list) {
            if (null == itemEntity.getParentItem() || !itemEntity.getParentItem().equals(entity.getId())) continue;
            User createUser = UserCache.getUser((Long)itemEntity.getCreateUser());
            itemEntity.setCreateUserName((String)Optional.ofNullable(createUser).map(User::getName).orElse(null));
            child.add(itemEntity);
            itemEntity.setChildren(this.findChildren(itemEntity, list));
        }
        return child;
    }

    public R<List<CheckItemVo>> getTreeList(CheckItemDTO req) {
        4 queryWrapper = new /* Unavailable Anonymous Inner Class!! */;
        List list = this.list((Wrapper)queryWrapper);
        5 queryWrapper2 = new /* Unavailable Anonymous Inner Class!! */;
        List allItem = this.list((Wrapper)queryWrapper2);
        list.forEach(entity -> entity.setChildren(this.findChildren(entity, allItem)));
        return R.data((Object)CheckItemWrapper.build().listVO(list));
    }

    public boolean enable(CheckItemDTO req) {
        boolean result = this.updateById((BaseEntity)req);
        if (result) {
            List allItem = this.list();
            this.setChildren((CheckItemEntity)req, allItem);
        }
        return result;
    }

    private void setChildren(CheckItemEntity entity, List<CheckItemEntity> list) {
        for (CheckItemEntity itemEntity : list) {
            if (null == itemEntity.getParentItem() || !itemEntity.getParentItem().equals(entity.getId())) continue;
            itemEntity.setStatus(entity.getStatus());
            this.updateById((BaseEntity)itemEntity);
            this.setChildren(itemEntity, list);
        }
    }

    public CheckItemServiceImpl(CheckItemMapper checkItemMapper, CheckItemInstanceMapper checkItemInstanceMapper, IDutyRecClient dutyRecClient, SafeEquipmentTrialService safeEquipmentTrialService, IOperateTicketClient operateTicketClient, ITicketInfoClient ticketInfoClient, IInspectTaskClient inspectTaskClient, IOperTaskClient operTaskClient, ICheckQuarterService checkQuarterService, ISysClient sysClient) {
        this.checkItemMapper = checkItemMapper;
        this.checkItemInstanceMapper = checkItemInstanceMapper;
        this.dutyRecClient = dutyRecClient;
        this.safeEquipmentTrialService = safeEquipmentTrialService;
        this.operateTicketClient = operateTicketClient;
        this.ticketInfoClient = ticketInfoClient;
        this.inspectTaskClient = inspectTaskClient;
        this.operTaskClient = operTaskClient;
        this.checkQuarterService = checkQuarterService;
        this.sysClient = sysClient;
    }
}

