/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hnac.hzims.message.MessageConstants;
import com.hnac.hzims.message.dto.AppPushDto;
import com.hnac.hzims.message.dto.WsPushDto;
import com.hnac.hzims.message.fegin.IPushMsgClient;
import com.hnac.hzims.safeproduct.dto.CheckNoticeDTO;
import com.hnac.hzims.safeproduct.entity.CheckNoticeEntity;
import com.hnac.hzims.safeproduct.mapper.CheckNoticeMapper;
import com.hnac.hzims.safeproduct.service.ICheckNoticeService;
import com.hnac.hzims.safeproduct.service.impl.CheckNoticeServiceImpl;
import com.hnac.hzims.safeproduct.vo.CheckNoticeVo;
import com.hnac.hzims.safeproduct.wrapper.CheckNoticeWrapper;
import com.hnac.hzinfo.core.push.enums.PushAudienceType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.base.BaseServiceImpl;
import org.springblade.core.mp.support.Condition;
import org.springblade.core.mp.support.Query;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.api.R;
import org.springblade.system.user.feign.IUserClient;
import org.springframework.stereotype.Service;

@Service
public class CheckNoticeServiceImpl
extends BaseServiceImpl<CheckNoticeMapper, CheckNoticeEntity>
implements ICheckNoticeService {
    private static final Logger log = LoggerFactory.getLogger(CheckNoticeServiceImpl.class);
    private final CheckNoticeMapper CheckNoticeMapper;
    private final IPushMsgClient pushMsgClient;
    private final IUserClient userClient;

    public boolean doSave(CheckNoticeDTO req) {
        boolean result = this.save((BaseEntity)req);
        if (result) {
            CompletableFuture.runAsync(() -> this.senMessage(req));
        }
        return result;
    }

    public boolean doUpdate(CheckNoticeDTO req) {
        boolean result = this.updateById((BaseEntity)req);
        if (result) {
            CompletableFuture.runAsync(() -> this.senMessage(req));
        }
        return result;
    }

    private void senMessage(CheckNoticeDTO req) {
        if (StringUtils.isNotEmpty((String)req.getStation())) {
            StringBuilder sb = new StringBuilder();
            sb.append(req.getYear()).append("\u5e74").append(req.getQuarter()).append("\u5b63\u5ea6").append(" ").append("\u5f00\u59cb\u65e5\u671f\uff1a").append(req.getStartDate()).append(" ").append("\u7ed3\u675f\u65e5\u671f\uff1a").append(req.getEndDate()).append(System.lineSeparator()).append(req.getContent());
            List<String> stationIds = Arrays.asList(req.getStation().split(","));
            stationIds.forEach(stationId -> {
                R list = this.userClient.relationUserListByRoleAlias(AuthUtil.getTenantId(), Long.valueOf(Long.parseLong(stationId)), "stationAgent");
                if (list.isSuccess()) {
                    List users = (List)list.getData();
                    if (users.size() > 0) {
                        List userIds = users.stream().map(user -> String.valueOf(user.getId())).collect(Collectors.toList());
                        AppPushDto appPushDto = new AppPushDto();
                        appPushDto.setBusinessClassify(MessageConstants.BusinessClassifyEnum.SAFE_PRODUCT.getKey());
                        appPushDto.setBusinessKey("quarter_check");
                        appPushDto.setIsAll(Boolean.valueOf(true));
                        appPushDto.setContent(sb.toString());
                        appPushDto.setSubject("\u5b63\u5ea6\u5927\u68c0\u67e5\u901a\u77e5");
                        appPushDto.setTitle("\u5b63\u5ea6\u5927\u68c0\u67e5\u901a\u77e5");
                        appPushDto.setAudienceType(PushAudienceType.TAG);
                        appPushDto.setTags(userIds);
                        appPushDto.setPushAlert(sb.toString());
                        this.pushMsgClient.sendPush(appPushDto);
                        WsPushDto wsPushDto = new WsPushDto();
                        wsPushDto.setBusinessClassify(MessageConstants.BusinessClassifyEnum.SAFE_PRODUCT.getKey());
                        wsPushDto.setBusinessKey("quarter_check");
                        wsPushDto.setContent(sb.toString());
                        wsPushDto.setSubject("\u5b63\u5ea6\u5927\u68c0\u67e5\u901a\u77e5");
                        wsPushDto.setUserIdList(userIds);
                        wsPushDto.setText(sb.toString());
                        this.pushMsgClient.sendWebsocket(wsPushDto);
                    }
                } else {
                    log.error("\u5b63\u5ea6\u5927\u68c0\u67e5\u901a\u77e5\u83b7\u53d6\u7ad9\u957f\u5931\u8d25");
                }
            });
        }
    }

    public R<CheckNoticeVo> detail(Long id) {
        CheckNoticeEntity entity = (CheckNoticeEntity)this.CheckNoticeMapper.selectById((Serializable)id);
        if (null == entity) {
            throw new RuntimeException("\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        CheckNoticeVo vo = CheckNoticeWrapper.build().entityVO(entity);
        return R.data((Object)vo);
    }

    public R<IPage<CheckNoticeVo>> pageCondition(CheckNoticeDTO req, Query query) {
        1 queryWrapper = new /* Unavailable Anonymous Inner Class!! */;
        IPage page = super.page(Condition.getPage((Query)query), (Wrapper)queryWrapper);
        page.setRecords(CheckNoticeWrapper.build().listVO(page.getRecords()));
        return R.data((Object)page);
    }

    public CheckNoticeServiceImpl(CheckNoticeMapper CheckNoticeMapper2, IPushMsgClient pushMsgClient, IUserClient userClient) {
        this.CheckNoticeMapper = CheckNoticeMapper2;
        this.pushMsgClient = pushMsgClient;
        this.userClient = userClient;
    }
}

