/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hnac.hzims.safeproduct.dto.CheckQuarterDTO;
import com.hnac.hzims.safeproduct.entity.CheckItemEntity;
import com.hnac.hzims.safeproduct.entity.CheckItemInstanceEntity;
import com.hnac.hzims.safeproduct.entity.CheckQuarterEntity;
import com.hnac.hzims.safeproduct.mapper.CheckQuarterMapper;
import com.hnac.hzims.safeproduct.service.ICheckItemInstanceService;
import com.hnac.hzims.safeproduct.service.ICheckQuarterService;
import com.hnac.hzims.safeproduct.service.impl.CheckQuarterServiceImpl;
import com.hnac.hzims.safeproduct.vo.CheckQuarterVo;
import com.hnac.hzims.safeproduct.wrapper.CheckQuarterWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.base.BaseServiceImpl;
import org.springblade.core.mp.support.Condition;
import org.springblade.core.mp.support.Query;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.Func;
import org.springframework.stereotype.Service;

@Service
public class CheckQuarterServiceImpl
extends BaseServiceImpl<CheckQuarterMapper, CheckQuarterEntity>
implements ICheckQuarterService {
    private static final Logger log = LoggerFactory.getLogger(CheckQuarterServiceImpl.class);
    private final CheckQuarterMapper CheckQuarterMapper;
    private final ICheckItemInstanceService itemInstanceService;

    public R doSave(CheckQuarterDTO req) {
        List entityList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CheckQuarterEntity::getYear, (Object)req.getYear())).eq(CheckQuarterEntity::getQuarter, (Object)req.getQuarter()));
        if (entityList.size() > 0) {
            return R.fail((String)"\u8be5\u5b63\u5ea6\u5df2\u5b58\u5728");
        }
        boolean result = this.save((BaseEntity)req);
        if (result) {
            Long checkId = req.getId();
            List items = req.getItems();
            items.forEach(item -> {
                item.setOid(item.getId());
                item.setId(null);
                item.setCheckId(checkId);
            });
            this.itemInstanceService.saveBatch((Collection)items);
        }
        return R.status((boolean)result);
    }

    public boolean doUpdate(CheckQuarterDTO req) {
        boolean result = this.updateById((BaseEntity)req);
        if (result) {
            List items = req.getItems();
            items.forEach(arg_0 -> ((ICheckItemInstanceService)this.itemInstanceService).updateById(arg_0));
        }
        return result;
    }

    public R<CheckQuarterVo> detail(Long id) {
        CheckQuarterEntity entity = (CheckQuarterEntity)this.CheckQuarterMapper.selectById((Serializable)id);
        CheckQuarterVo vo = CheckQuarterWrapper.build().entityVO(entity);
        QueryWrapper queryMapper = new QueryWrapper();
        queryMapper.eq((Object)"CHECK_ID", (Object)vo.getId());
        queryMapper.orderByAsc((Object)"SORT");
        List items = this.itemInstanceService.list((Wrapper)queryMapper);
        items.forEach(item -> item.setChildren(this.findChildren(item, items)));
        vo.setItems(items);
        return R.data((Object)vo);
    }

    private List<CheckItemEntity> findChildren(CheckItemInstanceEntity entity, List<CheckItemInstanceEntity> list) {
        ArrayList<CheckItemEntity> child = new ArrayList<CheckItemEntity>();
        for (CheckItemInstanceEntity itemEntity : list) {
            if (null == itemEntity.getParentItem() || !itemEntity.getParentItem().equals(entity.getOid())) continue;
            child.add((CheckItemEntity)itemEntity);
            itemEntity.setChildren(this.findChildren(itemEntity, list));
        }
        return child;
    }

    public boolean doDelete(String ids) {
        List list = Func.toLongList((String)ids);
        boolean result = this.deleteLogic(list);
        if (result) {
            list.forEach(id -> {
                QueryWrapper queryMapper = new QueryWrapper();
                queryMapper.eq((Object)"CHECK_ID", id);
                this.itemInstanceService.remove((Wrapper)queryMapper);
            });
        }
        return result;
    }

    public R<IPage<CheckQuarterVo>> pageCondition(CheckQuarterEntity req, Query query) {
        1 queryWrapper = new /* Unavailable Anonymous Inner Class!! */;
        IPage page = this.page(Condition.getPage((Query)query), (Wrapper)queryWrapper);
        page.setRecords(CheckQuarterWrapper.build().listVO(page.getRecords()));
        return R.data((Object)page);
    }

    public R<IPage<CheckQuarterVo>> pageNotDataScope(CheckQuarterEntity req, Query query) {
        IPage page = this.CheckQuarterMapper.pageNotDataScope(Condition.getPage((Query)query), req);
        page.setRecords(CheckQuarterWrapper.build().listVO(page.getRecords()));
        return R.data((Object)page);
    }

    public CheckQuarterServiceImpl(CheckQuarterMapper CheckQuarterMapper2, ICheckItemInstanceService itemInstanceService) {
        this.CheckQuarterMapper = CheckQuarterMapper2;
        this.itemInstanceService = itemInstanceService;
    }
}

