/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.service.impl;

import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hnac.hzims.equipment.entity.EmInfoEntity;
import com.hnac.hzims.equipment.feign.IEmInfoClient;
import com.hnac.hzims.safeproduct.dto.DangerSourceDTO;
import com.hnac.hzims.safeproduct.dto.DangerSourcePositionDTO;
import com.hnac.hzims.safeproduct.entity.DangerSourceEntity;
import com.hnac.hzims.safeproduct.entity.DangerSourcePositionEntity;
import com.hnac.hzims.safeproduct.enums.DangerSourceLevelEnum;
import com.hnac.hzims.safeproduct.excel.DangerSourceSaveExcel;
import com.hnac.hzims.safeproduct.mapper.DangerSourceLevelRecordMapper;
import com.hnac.hzims.safeproduct.mapper.DangerSourceMapper;
import com.hnac.hzims.safeproduct.mapper.DangerSourcePositionMapper;
import com.hnac.hzims.safeproduct.service.IDangerSourceService;
import com.hnac.hzims.safeproduct.service.impl.DangerSourceServiceImpl;
import com.hnac.hzims.safeproduct.utils.ExcelToolListener;
import com.hnac.hzims.safeproduct.utils.ExcelUtil;
import com.hnac.hzims.safeproduct.utils.TableJsonUtils;
import com.hnac.hzims.safeproduct.vo.DangerSourcePositionVO;
import com.hnac.hzims.safeproduct.vo.DangerSourceReportVO;
import com.hnac.hzims.safeproduct.vo.DangerSourceVO;
import com.hnac.hzims.safeproduct.vo.SourceVO;
import com.hnac.hzims.safeproduct.wrapper.DangerSourcePostionWrapper;
import com.hnac.hzims.safeproduct.wrapper.DangerSourceWrapper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.excel.support.ExcelException;
import org.springblade.core.log.exception.ServiceException;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.base.BaseServiceImpl;
import org.springblade.core.mp.support.Condition;
import org.springblade.core.mp.support.Query;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.StringUtil;
import org.springblade.system.cache.DictCache;
import org.springblade.system.vo.CreateTableVO;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DangerSourceServiceImpl
extends BaseServiceImpl<DangerSourceMapper, DangerSourceEntity>
implements IDangerSourceService {
    private static final Logger log = LoggerFactory.getLogger(DangerSourceServiceImpl.class);
    private final DangerSourceMapper dangerSourceMapper;
    private final DangerSourcePositionMapper dangerSourcePositionMapper;
    private final DangerSourceLevelRecordMapper dangerSourceLevelRecordMapper;
    private final IEmInfoClient emInfoClient;
    private final JdbcTemplate jdbcTemplate;

    public R doSave(DangerSourceDTO req) {
        1 levelRecordEntity;
        if (!super.save((BaseEntity)req)) {
            throw new RuntimeException("\u6570\u636e\u5e93insert\u5931\u8d25\uff01");
        }
        if (null != req.getPosition()) {
            req.getPosition().setSourceId(req.getId());
            if (this.dangerSourcePositionMapper.insert((Object)req.getPosition()) == 0) {
                throw new RuntimeException("\u6570\u636e\u5e93insert\u5931\u8d25\uff01");
            }
        }
        if (this.dangerSourceLevelRecordMapper.insert((Object)(levelRecordEntity = new /* Unavailable Anonymous Inner Class!! */)) == 0) {
            throw new RuntimeException("\u6570\u636e\u5e93insert\u5931\u8d25\uff01");
        }
        return R.data((Object)req.getId());
    }

    public R doUpdate(DangerSourceDTO req) {
        DangerSourceEntity orginDangerSource = (DangerSourceEntity)this.dangerSourceMapper.selectById((Serializable)req.getId());
        if (null == orginDangerSource) {
            throw new RuntimeException("\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        if (!super.updateById((BaseEntity)req)) {
            throw new RuntimeException("\u6570\u636e\u5e93update\u5931\u8d25\uff01");
        }
        if (null != req.getPosition()) {
            2 queryWrapper = new /* Unavailable Anonymous Inner Class!! */;
            req.getPosition().setSourceId(req.getId());
            int line = null == this.dangerSourcePositionMapper.selectOne((Wrapper)queryWrapper) ? this.dangerSourcePositionMapper.insert((Object)req.getPosition()) : this.dangerSourcePositionMapper.update((Object)req.getPosition(), (Wrapper)queryWrapper);
            if (line == 0) {
                throw new RuntimeException("\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
        return R.data((Object)req.getId());
    }

    public R<DangerSourceVO> detail(Long id) {
        DangerSourceEntity dangerSource = (DangerSourceEntity)this.dangerSourceMapper.selectById((Serializable)id);
        if (null == dangerSource) {
            throw new RuntimeException("\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        DangerSourcePositionEntity dangerSourcePosition = (DangerSourcePositionEntity)this.dangerSourcePositionMapper.selectOne((Wrapper)new /* Unavailable Anonymous Inner Class!! */);
        DangerSourceVO detail = DangerSourceWrapper.build().entityVO(dangerSource);
        DangerSourcePositionVO position = DangerSourcePostionWrapper.build().entityVO(dangerSourcePosition);
        detail.setPosition(position);
        return R.data((Object)detail);
    }

    public R<IPage<DangerSourceVO>> pageCondition(DangerSourceEntity req, Query query) {
        4 queryWrapper = new /* Unavailable Anonymous Inner Class!! */;
        IPage page = super.page(Condition.getPage((Query)query), (Wrapper)queryWrapper);
        page.setRecords(DangerSourceWrapper.build().listVO(page.getRecords()));
        return R.data((Object)page);
    }

    @Transactional(rollbackFor={Exception.class})
    public void importExcel(MultipartFile file) {
        String filename = file.getOriginalFilename();
        ExcelToolListener excelToolListener = new ExcelToolListener();
        if (StringUtils.isEmpty((Object)filename)) {
            throw new ExcelException("\u8bf7\u4e0a\u4f20\u6587\u4ef6!");
        }
        if (!StringUtils.endsWithIgnoreCase((String)filename, (String)".xls") && !StringUtils.endsWithIgnoreCase((String)filename, (String)".xlsx")) {
            throw new ExcelException("\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684excel\u6587\u4ef6!");
        }
        try {
            BufferedInputStream inputStream = new BufferedInputStream(file.getInputStream());
            ExcelUtil.asyncReadModel((InputStream)inputStream, (AnalysisEventListener)excelToolListener, DangerSourceSaveExcel.class, (Integer)0, (Integer)1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List dataList = excelToolListener.getDataList();
        AtomicInteger index = new AtomicInteger(1);
        dataList.forEach(data -> {
            JSONObject object = JSONObject.parseObject((String)JSON.toJSONString((Object)data));
            DangerSourceDTO dangerSourceDTO = (DangerSourceDTO)BeanUtil.copy((Object)data, DangerSourceDTO.class);
            if (Func.isEmpty((Object)object.getString("applyTypeName")) || Func.isEmpty((Object)object.getString("typeName")) || Func.isEmpty((Object)object.getString("levelName")) || Func.isEmpty((Object)object.getString("name")) || Func.isEmpty((Object)object.getString("dangerEle")) || Func.isEmpty((Object)object.getString("cause")) || Func.isEmpty((Object)object.getString("measures"))) {
                throw new ServiceException("\u7b2c" + index.get() + "\u884c\u586b\u5165\u6570\u636e\u4e0d\u5168\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u518d\u5bfc\u5165");
            }
            String appType = DictCache.getKey((String)"safe_danger_source_apply_type", (String)object.getString("applyTypeName"));
            if (StringUtil.isEmpty((Object)appType)) {
                throw new ServiceException("\u7b2c" + index.get() + "\u884c\u586b\u5165\u5e94\u7528\u7c7b\u578b\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165");
            }
            dangerSourceDTO.setApplyType(appType);
            String type = DictCache.getKey((String)"dangerType", (String)object.getString("typeName"));
            if (StringUtil.isEmpty((Object)type)) {
                throw new ServiceException("\u7b2c" + index.get() + "\u884c\u586b\u5165\u5371\u9669\u6e90\u7c7b\u578b\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165");
            }
            dangerSourceDTO.setType(Integer.valueOf(type));
            String level = DictCache.getKey((String)"riskLevel", (String)object.getString("levelName"));
            if (StringUtil.isEmpty((Object)level)) {
                throw new ServiceException("\u7b2c" + index.get() + "\u884c\u586b\u5165\u98ce\u9669\u7b49\u7ea7\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165");
            }
            if (Func.isNotEmpty((Object)object.getString("equName"))) {
                String equName = object.getString("equName");
                R emInfoR = this.emInfoClient.getEmInfoByName(equName);
                log.info("\u8bbe\u5907\u67e5\u8be2\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSONObject.toJSONString((Object)emInfoR));
                if (!emInfoR.isSuccess() || Func.isEmpty((Object)emInfoR.getData())) {
                    throw new ServiceException("\u7b2c" + index.get() + "\u884c\u586b\u5165\u8bbe\u5907\u4fe1\u606f\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165");
                }
                dangerSourceDTO.setEqId(((EmInfoEntity)emInfoR.getData()).getId());
            }
            dangerSourceDTO.setLevel(Integer.valueOf(level));
            DangerSourcePositionDTO positionDTO = (DangerSourcePositionDTO)BeanUtil.copy((Object)object, DangerSourcePositionDTO.class);
            dangerSourceDTO.setPosition(positionDTO);
            this.doSave(dangerSourceDTO);
            index.getAndIncrement();
        });
    }

    public List<DangerSourceReportVO> getLevelCount() {
        List re = this.dangerSourceMapper.getLevelCount();
        if (Func.isNotEmpty((Object)re)) {
            for (DangerSourceReportVO vo : re) {
                vo.setName(DangerSourceLevelEnum.getName((int)vo.getLevel()));
            }
        }
        return re;
    }

    public List<CreateTableVO> getSafeCreateTable(List<String> tableNames) {
        if (CollectionUtil.isEmpty(tableNames)) {
            return null;
        }
        String databaseName = ((DangerSourceMapper)this.baseMapper).getCurDataBaseName();
        ArrayList<CreateTableVO> list = new ArrayList<CreateTableVO>();
        tableNames.forEach(table -> {
            CreateTableVO item = new CreateTableVO();
            String show_table_sql = "show create table " + databaseName + "." + table;
            Map result = this.jdbcTemplate.queryForMap(show_table_sql);
            if (MapUtils.isEmpty((Map)result)) {
                return;
            }
            String createTableSql = result.get("Create Table").toString();
            item.setTableName((String)result.get("Table"));
            item.setCreateSql(TableJsonUtils.createTableSqlProcess((String)createTableSql));
            list.add(item);
        });
        return list;
    }

    public List<SourceVO> listByTenantId(String tenantId) {
        return ((DangerSourceMapper)this.baseMapper).listByTenantId(tenantId);
    }

    public DangerSourceServiceImpl(DangerSourceMapper dangerSourceMapper, DangerSourcePositionMapper dangerSourcePositionMapper, DangerSourceLevelRecordMapper dangerSourceLevelRecordMapper, IEmInfoClient emInfoClient, JdbcTemplate jdbcTemplate) {
        this.dangerSourceMapper = dangerSourceMapper;
        this.dangerSourcePositionMapper = dangerSourcePositionMapper;
        this.dangerSourceLevelRecordMapper = dangerSourceLevelRecordMapper;
        this.emInfoClient = emInfoClient;
        this.jdbcTemplate = jdbcTemplate;
    }
}

