/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.service.impl;

import com.hnac.hzims.operational.duty.entity.ImsDutyMainEntity;
import com.hnac.hzims.operational.duty.enume.JoinStatus;
import com.hnac.hzims.operational.duty.feign.IDutyMainClient;
import com.hnac.hzims.safeproduct.entity.ImsMonAlarmInfoEntity;
import com.hnac.hzims.safeproduct.mapper.ImsMonAlarmInfoMapper;
import com.hnac.hzims.safeproduct.service.IImsMonAlarmInfoService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.log.exception.ServiceException;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.base.BaseServiceImpl;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.StringUtil;
import org.springframework.stereotype.Service;

@Service
public class ImsMonAlarmInfoServiceImpl
extends BaseServiceImpl<ImsMonAlarmInfoMapper, ImsMonAlarmInfoEntity>
implements IImsMonAlarmInfoService {
    private static final Logger log = LoggerFactory.getLogger(ImsMonAlarmInfoServiceImpl.class);
    private final IDutyMainClient dutyMainClient;

    public boolean save(ImsMonAlarmInfoEntity entity) {
        this.checkParam(entity);
        ArrayList<ImsMonAlarmInfoEntity> entityList = new ArrayList<ImsMonAlarmInfoEntity>();
        ImsDutyMainEntity query = new ImsDutyMainEntity();
        query.setTenantId(entity.getTenantId());
        query.setStatus(Integer.valueOf(JoinStatus.DUTY_ING.getStatus()));
        query.setDutyDate(DateUtil.now());
        List dutyList = (List)this.dutyMainClient.list(query).getData();
        String personIdStr = "";
        if (Func.isNotEmpty((Object)dutyList)) {
            HashSet<String> personIdSet = new HashSet<String>();
            if (dutyList.size() > 0) {
                for (ImsDutyMainEntity duty : dutyList) {
                    String[] personIds = StringUtil.splitTrim((String)duty.getDutyPersonIds(), (String)"^");
                    personIdSet.addAll(Arrays.asList(personIds));
                }
            }
            personIdStr = StringUtils.join((Object[])personIdSet.toArray(), (String)"^");
            for (String personId : personIdSet) {
                ImsMonAlarmInfoEntity copy = (ImsMonAlarmInfoEntity)BeanUtil.copy((Object)entity, ImsMonAlarmInfoEntity.class);
                copy.setAcceptUserId(Long.valueOf(personId));
                entityList.add(copy);
            }
        } else {
            entityList.add(entity);
        }
        boolean re = super.saveBatch(entityList, entityList.size());
        return re;
    }

    public boolean updateById(ImsMonAlarmInfoEntity entity) {
        return super.updateById((BaseEntity)entity);
    }

    private void checkParam(ImsMonAlarmInfoEntity entity) {
        if (Func.isEmpty((Object)entity.getCameraId())) {
            throw new ServiceException("\u544a\u8b66\u6444\u50cf\u5934ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Func.isEmpty((Object)entity.getTenantId())) {
            throw new ServiceException("\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Func.isEmpty((Object)entity.getAlarmTime())) {
            throw new ServiceException("\u544a\u8b66\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Func.isEmpty((Object)entity.getAlarmContent())) {
            throw new ServiceException("\u544a\u8b66\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Func.isEmpty((Object)entity.getMonitorItem())) {
            throw new ServiceException("\u544a\u8b66\u68c0\u6d4b\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Func.isEmpty((Object)entity.getPicLink())) {
            throw new ServiceException("\u544a\u8b66\u56fe\u7247\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Func.isEmpty((Object)entity.getPicOriginalName())) {
            throw new ServiceException("\u544a\u8b66\u56fe\u7247originalName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public ImsMonAlarmInfoServiceImpl(IDutyMainClient dutyMainClient) {
        this.dutyMainClient = dutyMainClient;
    }
}

