/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.service.impl;

import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.zxing.BarcodeFormat;
import com.hnac.hzims.safeproduct.dto.SafetyToolBatchRecheckDTO;
import com.hnac.hzims.safeproduct.dto.SafetyToolDTO;
import com.hnac.hzims.safeproduct.entity.SafeProductPdf;
import com.hnac.hzims.safeproduct.entity.SafetyToolEntity;
import com.hnac.hzims.safeproduct.entity.SafetyToolRecheckEntity;
import com.hnac.hzims.safeproduct.entity.SafetyToolTypeEntity;
import com.hnac.hzims.safeproduct.excel.SafetyToolExcel;
import com.hnac.hzims.safeproduct.excel.SafetyToolSaveExcel;
import com.hnac.hzims.safeproduct.mapper.SafetyToolMapper;
import com.hnac.hzims.safeproduct.mapper.SafetyToolRecheckMapper;
import com.hnac.hzims.safeproduct.mapper.SafetyToolTypeMapper;
import com.hnac.hzims.safeproduct.service.ISafetyToolService;
import com.hnac.hzims.safeproduct.service.impl.SafetyToolTypeServiceImpl;
import com.hnac.hzims.safeproduct.utils.ExcelToolListener;
import com.hnac.hzims.safeproduct.utils.ExcelUtil;
import com.hnac.hzims.safeproduct.utils.HtmlModule;
import com.hnac.hzims.safeproduct.utils.HtmltoPdf;
import com.hnac.hzims.safeproduct.utils.ZXingGenCode;
import com.hnac.hzims.safeproduct.vo.SafetyToolVO;
import com.hnac.hzims.safeproduct.wrapper.SafetyToolWrapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.excel.support.ExcelException;
import org.springblade.core.log.exception.ServiceException;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.base.BaseServiceImpl;
import org.springblade.core.mp.support.Condition;
import org.springblade.core.mp.support.Query;
import org.springblade.core.secure.utils.AuthUtil;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.core.tool.utils.ObjectUtil;
import org.springblade.system.feign.ISysClient;
import org.springblade.system.user.entity.User;
import org.springblade.system.user.feign.IUserClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SafetyToolServiceImpl
extends BaseServiceImpl<SafetyToolMapper, SafetyToolEntity>
implements ISafetyToolService {
    private static final Logger log = LoggerFactory.getLogger(SafetyToolServiceImpl.class);
    private final HttpServletResponse httpServletResponse;
    private final ISysClient sysClient;
    private final SafetyToolTypeServiceImpl safetyToolTypeService;
    private final SafetyToolMapper safetyToolMapper;
    private final SafetyToolTypeMapper safetyToolTypeMapper;
    private final SafetyToolRecheckMapper safetyToolRecheckMapper;
    private final RedisTemplate redisTemplate;
    private final IUserClient userClient;
    @Value(value="${hzims.safeProduct.safeTool.sadeToolKey}")
    private String sadeToolKey;
    @Value(value="${hzims.tenantId}")
    private String tenantId;
    @Value(value="${hzims.safeProduct.safeTool.filePath}")
    private String uploadPath;
    @Value(value="${hzims.safeProduct.safeTool.modulePath}")
    private String modulePath;
    private static final String UPLOAD_IMG_SUFFIX = ".jpg";

    public R doSave(SafetyToolEntity req) {
        String toolCode = req.getToolCode();
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(SafetyToolEntity::getToolCode, (Object)toolCode));
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return R.fail((int)400, (String)String.format("\u7f16\u53f7[%s]\u5df2\u7ecf\u88ab\u4f7f\u7528\uff01", toolCode));
        }
        return R.status((boolean)super.save((BaseEntity)req));
    }

    public R doUpdate(SafetyToolEntity req) {
        String toolCode = req.getToolCode();
        SafetyToolEntity entity = (SafetyToolEntity)this.safetyToolMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SafetyToolEntity::getToolCode, (Object)toolCode));
        if (entity != null && !entity.getId().equals(req.getId())) {
            return R.fail((int)400, (String)String.format("\u7f16\u53f7[%s]\u5df2\u7ecf\u88ab\u4f7f\u7528\uff01", toolCode));
        }
        return R.status((boolean)super.updateById((BaseEntity)req));
    }

    public R<IPage<SafetyToolVO>> pageCondition(SafetyToolDTO req, Query query) {
        IPage page = super.page(Condition.getPage((Query)query), this.getListCondition(req));
        page.setRecords(SafetyToolWrapper.build().listVO(page.getRecords()));
        return R.data((Object)page);
    }

    public R<List<SafetyToolVO>> queryByCondition(SafetyToolDTO req) {
        List list = this.safetyToolMapper.selectList(this.getListCondition(req));
        return R.data((Object)SafetyToolWrapper.build().listVO(list));
    }

    public void doBatchRecheck(SafetyToolBatchRecheckDTO req) {
        Date currentTime = new Date();
        Long userId = AuthUtil.getUserId();
        String userName = AuthUtil.getUserName();
        List safetyTools = this.safetyToolMapper.selectBatchIds((Collection)req.getToolIds());
        for (SafetyToolEntity item : safetyTools) {
            item.setLastCheckTime(currentTime);
            item.setNextCheckTime(DateUtil.plusDays((Date)currentTime, (long)Long.valueOf(item.getSafeTime().toString())));
        }
        if (!super.updateBatchById((Collection)safetyTools)) {
            throw new RuntimeException("\u6570\u636e\u5e93update\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        ArrayList<SafetyToolRecheckEntity> safetyToolRechecks = new ArrayList<SafetyToolRecheckEntity>(safetyTools.size());
        for (SafetyToolEntity item : safetyTools) {
            SafetyToolRecheckEntity entity = new SafetyToolRecheckEntity();
            entity.setCheckUserName(userName);
            entity.setCheckUserId(userId);
            entity.setToolId(item.getId());
            entity.setCheckTime(currentTime);
            entity.setRemark(req.getRemark());
            safetyToolRechecks.add(entity);
        }
        if (this.safetyToolRecheckMapper.insertBatch(safetyToolRechecks) == 0) {
            throw new RuntimeException("\u6570\u636e\u5e93insert\u64cd\u4f5c\u5931\u8d25\uff01");
        }
    }

    public void exportExcel(SafetyToolDTO req) {
        List list = this.safetyToolMapper.selectList(this.getListCondition(req));
        List data = SafetyToolWrapper.build().entityExcelList(list, this.sysClient, this.safetyToolTypeMapper);
        org.springblade.core.excel.util.ExcelUtil.export((HttpServletResponse)this.httpServletResponse, (String)("\u5b89\u5168\u5de5\u5668\u5177" + System.currentTimeMillis()), (String)"\u5b89\u5168\u5de5\u5668\u5177", (List)data, SafetyToolExcel.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void importExcel(MultipartFile file, Long createDept) {
        String filename = file.getOriginalFilename();
        ExcelToolListener excelToolListener = new ExcelToolListener();
        if (StringUtils.isEmpty((Object)filename)) {
            throw new ExcelException("\u8bf7\u4e0a\u4f20\u6587\u4ef6!");
        }
        if (!StringUtils.endsWithIgnoreCase((String)filename, (String)".xls") && !StringUtils.endsWithIgnoreCase((String)filename, (String)".xlsx")) {
            throw new ExcelException("\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684excel\u6587\u4ef6!");
        }
        try {
            BufferedInputStream inputStream = new BufferedInputStream(file.getInputStream());
            ExcelUtil.asyncReadModel((InputStream)inputStream, (AnalysisEventListener)excelToolListener, SafetyToolSaveExcel.class, (Integer)0, (Integer)1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List dataList = excelToolListener.getDataList();
        if (CollectionUtil.isNotEmpty((Collection)dataList)) {
            ArrayList entityList = new ArrayList();
            Map<String, List<SafetyToolEntity>> map = JSONArray.parseArray((String)JSON.toJSONString((Object)dataList), SafetyToolEntity.class).stream().filter(entity -> Func.isNotEmpty((Object)entity.getToolCode())).collect(Collectors.groupingBy(SafetyToolEntity::getToolCode));
            Assert.isTrue((boolean)CollectionUtil.isNotEmpty(map), () -> {
                throw new ServiceException("\u586b\u5165\u5de5\u5668\u5177\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            });
            IntStream.iterate(0, index -> index + 1).limit(dataList.size()).forEachOrdered(index -> {
                SafetyToolEntity entity = (SafetyToolEntity)BeanUtil.copy(dataList.get(index), SafetyToolEntity.class);
                SafetyToolSaveExcel safetyToolSaveExcel = (SafetyToolSaveExcel)JSONObject.parseObject((String)JSON.toJSONString(dataList.get(index)), SafetyToolSaveExcel.class);
                Assert.isTrue((Func.isNotEmpty((Object)entity.getToolCode()) && Func.isNotEmpty((Object)entity.getToolName()) && Func.isNotEmpty((Object)entity.getSafeTime()) && Func.isNotEmpty((Object)safetyToolSaveExcel.getTypeName()) ? 1 : 0) != 0, () -> {
                    throw new ServiceException("\u7b2c" + index + "\u586b\u5165\u6570\u636e\u90e8\u5206\u7f3a\u5931\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165");
                });
                List list = this.list((Wrapper)new LambdaQueryWrapper().eq(SafetyToolEntity::getToolCode, (Object)entity.getToolCode()));
                if (CollectionUtil.isNotEmpty((Collection)list) || CollectionUtil.isNotEmpty((Collection)((Collection)map.get(entity.getToolCode()))) && ((List)map.get(entity.getToolCode())).size() > 1) {
                    throw new ServiceException(String.format("\u7f16\u53f7[%s]\u5df2\u7ecf\u88ab\u4f7f\u7528\uff01", entity.getToolCode()));
                }
                List safetyToolTypeEntityList = this.safetyToolTypeService.list((Wrapper)Wrappers.lambdaQuery().eq(SafetyToolTypeEntity::getTypeName, (Object)safetyToolSaveExcel.getTypeName()));
                Assert.isTrue((safetyToolTypeEntityList.size() > 0 ? 1 : 0) != 0, () -> {
                    throw new ServiceException("\u7b2c" + index + "\u884c\u586b\u5165\u7c7b\u578b\u672a\u627e\u5230\u76f8\u5173\u8bb0\u5f55,\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165");
                });
                String userIds = Arrays.stream(safetyToolSaveExcel.getAccounts().split(",")).map(account -> {
                    R userR = this.userClient.userByAccount(AuthUtil.getTenantId(), account);
                    Assert.isTrue((userR.isSuccess() && ObjectUtil.isNotEmpty((Object)userR.getData()) ? 1 : 0) != 0, () -> {
                        throw new ServiceException("\u7b2c" + index + "\u884c\u586b\u5165\u7528\u6237\u8d26\u53f7\u672a\u627e\u5230\u76f8\u5173\u8bb0\u5f55,\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165");
                    });
                    return (User)userR.getData();
                }).map(BaseEntity::getId).map(id -> Func.isNotEmpty((Object)id) ? id.toString() : "").collect(Collectors.joining(","));
                entity.setNoticeUsers(userIds);
                entity.setTypeId(((SafetyToolTypeEntity)safetyToolTypeEntityList.get(0)).getId());
                entity.setSendType(((SafetyToolTypeEntity)safetyToolTypeEntityList.get(0)).getSendType());
                entity.setCurSts(createDept);
                entityList.add(entity);
            });
            this.saveBatch(entityList);
        }
    }

    public String safetyToolRQExport(List idList) {
        List entityList = null;
        entityList = CollectionUtil.isNotEmpty((Collection)idList) ? this.list((Wrapper)new /* Unavailable Anonymous Inner Class!! */) : this.page(Condition.getPage((Query)new Query()), (Wrapper)new LambdaQueryWrapper()).getRecords();
        if (CollectionUtil.isNotEmpty((Collection)entityList)) {
            ArrayList pdfList = new ArrayList(entityList.size());
            entityList.forEach(entity -> {
                String imgPath = this.uploadPath + "/" + entity.getTenantId() + entity.getToolCode() + UPLOAD_IMG_SUFFIX;
                File file = new File(imgPath);
                if (!file.exists()) {
                    ZXingGenCode.encode((String)("AQQJ=" + entity.getId()), (int)200, (int)200, (String)imgPath, (BarcodeFormat)BarcodeFormat.QR_CODE);
                }
                SafeProductPdf safeProductPdf = new SafeProductPdf();
                safeProductPdf.setData_1(entity.getToolName());
                safeProductPdf.setData_2(DateUtil.format((Date)entity.getCreateTime(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                safeProductPdf.setData_3(imgPath);
                pdfList.add(safeProductPdf);
            });
            String pdfPath = this.uploadPath + "/" + UUID.randomUUID().toString() + ".pdf";
            try {
                String html = HtmlModule.buildHtml(pdfList, (String)this.modulePath);
                HtmltoPdf.htmlToPdf((String)html, (String)pdfPath);
                return pdfPath;
            }
            catch (Exception e) {
                throw new ServiceException("\u5bfc\u51fapdf\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        return null;
    }

    public R remove(List<Long> idList) {
        List toolEntityList = this.list((Wrapper)new /* Unavailable Anonymous Inner Class!! */);
        return R.status((boolean)this.deleteLogic(idList));
    }

    private void toolCodeUniquenessCheck(Long id, String toolCode) {
        SafetyToolEntity entity = (SafetyToolEntity)this.safetyToolMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SafetyToolEntity::getToolCode, (Object)toolCode));
        if (entity != null && !entity.getId().equals(id)) {
            throw new RuntimeException(String.format("\u7f16\u53f7[%s]\u5df2\u7ecf\u88ab\u4f7f\u7528\uff01", toolCode));
        }
    }

    private Wrapper<SafetyToolEntity> getListCondition(SafetyToolDTO req) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public SafetyToolServiceImpl(HttpServletResponse httpServletResponse, ISysClient sysClient, SafetyToolTypeServiceImpl safetyToolTypeService, SafetyToolMapper safetyToolMapper, SafetyToolTypeMapper safetyToolTypeMapper, SafetyToolRecheckMapper safetyToolRecheckMapper, RedisTemplate redisTemplate, IUserClient userClient) {
        this.httpServletResponse = httpServletResponse;
        this.sysClient = sysClient;
        this.safetyToolTypeService = safetyToolTypeService;
        this.safetyToolMapper = safetyToolMapper;
        this.safetyToolTypeMapper = safetyToolTypeMapper;
        this.safetyToolRecheckMapper = safetyToolRecheckMapper;
        this.redisTemplate = redisTemplate;
        this.userClient = userClient;
    }
}

