/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.hnac.hzims.safeproduct.dto.SafetyToolTypeBatchConfigDTO;
import com.hnac.hzims.safeproduct.dto.SafetyToolTypeDTO;
import com.hnac.hzims.safeproduct.dto.SafetyToolTypeListDTO;
import com.hnac.hzims.safeproduct.entity.SafetyToolTypeEntity;
import com.hnac.hzims.safeproduct.entity.SafetyToolTypeUserEntity;
import com.hnac.hzims.safeproduct.mapper.SafetyToolTypeMapper;
import com.hnac.hzims.safeproduct.mapper.SafetyToolTypeUserMapper;
import com.hnac.hzims.safeproduct.service.ISafetyToolTypeService;
import com.hnac.hzims.safeproduct.service.impl.SafetyToolTypeServiceImpl;
import com.hnac.hzims.safeproduct.vo.SafetyToolTypeVO;
import com.hnac.hzims.safeproduct.wrapper.SafetyToolTypeWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.base.BaseServiceImpl;
import org.springblade.core.mp.support.Condition;
import org.springblade.core.mp.support.Query;
import org.springblade.core.tool.utils.CollectionUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SafetyToolTypeServiceImpl
extends BaseServiceImpl<SafetyToolTypeMapper, SafetyToolTypeEntity>
implements ISafetyToolTypeService {
    private static final Logger log = LoggerFactory.getLogger(SafetyToolTypeServiceImpl.class);
    private final SafetyToolTypeMapper safetyToolTypeMapper;
    private final SafetyToolTypeUserMapper safetyToolTypeUserMapper;
    private final RedisTemplate redisTemplate;
    @Value(value="${hzims.safeProduct.safeTool.sadeToolKey}")
    private String sadeToolKey;

    public long doSave(SafetyToolTypeDTO req) {
        if (!super.save((BaseEntity)req)) {
            throw new RuntimeException("\u6570\u636e\u5e93insert\u64cd\u4f5c\u5931\u8d25\uff01");
        }
        this.insertBatchToolTypeUser(req.getId(), req.getUserIds());
        return req.getId();
    }

    public void doBatchConfig(SafetyToolTypeBatchConfigDTO req) {
        List typeUsers = this.safetyToolTypeUserMapper.selectList((Wrapper)new /* Unavailable Anonymous Inner Class!! */);
        if (CollectionUtil.isNotEmpty((Collection)typeUsers)) {
            String exitsIdStr = typeUsers.stream().map(o -> o.getTypeId().toString()).collect(Collectors.toSet()).stream().collect(Collectors.joining(",", "(", ")"));
            throw new RuntimeException("\u90e8\u5206\u8bb0\u5f55\u5df2\u7ecf\u6709\u5b89\u88c5\u8ba1\u5212" + exitsIdStr);
        }
        ArrayList<SafetyToolTypeUserEntity> list = new ArrayList<SafetyToolTypeUserEntity>();
        for (Long id : req.getIds()) {
            for (Long userId : req.getUserIds()) {
                SafetyToolTypeUserEntity entity = new SafetyToolTypeUserEntity();
                entity.setUserId(userId);
                entity.setTypeId(id);
                list.add(entity);
            }
        }
        if (this.safetyToolTypeUserMapper.insertBatch(list) == 0) {
            throw new RuntimeException("\u6570\u636e\u5e93insert\u64cd\u4f5c\u5931\u8d25\uff01");
        }
    }

    public void doEdit(SafetyToolTypeDTO req) {
        this.queryAndCheckExists(req.getId());
        super.updateById((BaseEntity)req);
        this.safetyToolTypeUserMapper.deleteByTypeId(req.getId());
        this.insertBatchToolTypeUser(req.getId(), req.getUserIds());
    }

    public SafetyToolTypeVO detail(Long id) {
        SafetyToolTypeEntity safetyToolType = this.queryAndCheckExists(id);
        SafetyToolTypeVO resp = SafetyToolTypeWrapper.build().entityVO(safetyToolType);
        resp.setUserIds(this.safetyToolTypeUserMapper.selectList((Wrapper)new /* Unavailable Anonymous Inner Class!! */).stream().map(SafetyToolTypeUserEntity::getUserId).collect(Collectors.toSet()));
        return resp;
    }

    public IPage pageCondition(SafetyToolTypeListDTO req, Query query) {
        3 queryWrapper = new /* Unavailable Anonymous Inner Class!! */;
        IPage pages = super.page(Condition.getPage((Query)query), (Wrapper)queryWrapper);
        pages.setRecords(SafetyToolTypeWrapper.build().listVO(pages.getRecords()));
        return pages;
    }

    public Map<String, String> getSelOption() {
        QueryWrapper queryWrapper = new QueryWrapper();
        return this.safetyToolTypeMapper.selectList((Wrapper)queryWrapper).stream().collect(Collectors.toMap(o -> o.getId().toString(), SafetyToolTypeEntity::getTypeName));
    }

    private SafetyToolTypeEntity queryAndCheckExists(Long id) {
        SafetyToolTypeEntity safetyToolType = (SafetyToolTypeEntity)this.safetyToolTypeMapper.selectById((Serializable)id);
        if (null == safetyToolType) {
            throw new RuntimeException("\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return safetyToolType;
    }

    private void insertBatchToolTypeUser(Long id, Set<Long> userIds) {
        if (CollectionUtil.isNotEmpty(userIds)) {
            ArrayList<SafetyToolTypeUserEntity> list = new ArrayList<SafetyToolTypeUserEntity>();
            for (Long userId : userIds) {
                SafetyToolTypeUserEntity entity = new SafetyToolTypeUserEntity();
                entity.setUserId(userId);
                entity.setTypeId(id);
                list.add(entity);
            }
            if (this.safetyToolTypeUserMapper.insertBatch(list) == 0) {
                throw new RuntimeException("\u6570\u636e\u5e93insert\u64cd\u4f5c\u5931\u8d25\uff01");
            }
        }
    }

    public SafetyToolTypeServiceImpl(SafetyToolTypeMapper safetyToolTypeMapper, SafetyToolTypeUserMapper safetyToolTypeUserMapper, RedisTemplate redisTemplate) {
        this.safetyToolTypeMapper = safetyToolTypeMapper;
        this.safetyToolTypeUserMapper = safetyToolTypeUserMapper;
        this.redisTemplate = redisTemplate;
    }
}

