/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hnac.hzims.safeproduct.Constants;
import com.hnac.hzims.safeproduct.dto.SystemFileListDTO;
import com.hnac.hzims.safeproduct.entity.SystemFileEntity;
import com.hnac.hzims.safeproduct.entity.SystemFileTypeEntity;
import com.hnac.hzims.safeproduct.mapper.SystemFileMapper;
import com.hnac.hzims.safeproduct.service.ISystemFileService;
import com.hnac.hzims.safeproduct.service.ISystemFileTypeService;
import com.hnac.hzims.safeproduct.service.impl.SystemFileServiceImpl;
import com.hnac.hzims.safeproduct.vo.SystemFileVO;
import com.hnac.hzims.safeproduct.wrapper.SystemFileWrapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springblade.core.log.exception.ServiceException;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.base.BaseServiceImpl;
import org.springblade.core.mp.support.Condition;
import org.springblade.core.mp.support.Query;
import org.springblade.core.tool.api.R;
import org.springblade.core.tool.utils.Func;
import org.springblade.flow.core.entity.BladeFlow;
import org.springblade.flow.core.feign.IFlowClient;
import org.springblade.flow.core.utils.FlowUtil;
import org.springblade.flow.core.vo.ComleteTask;
import org.springblade.system.user.feign.IUserClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemFileServiceImpl
extends BaseServiceImpl<SystemFileMapper, SystemFileEntity>
implements ISystemFileService {
    private final IFlowClient flowClient;
    private final IUserClient userClient;
    private final ISystemFileTypeService systemFileTypeService;
    @Value(value="${hzims.tenantId}")
    private String tenantId;

    public R<SystemFileVO> detail(Long id) {
        SystemFileEntity entity = (SystemFileEntity)super.getOne((Wrapper)new /* Unavailable Anonymous Inner Class!! */);
        SystemFileVO systemFileVO = SystemFileWrapper.build().entityVO(entity);
        SystemFileTypeEntity typeEntity = (SystemFileTypeEntity)this.systemFileTypeService.getById((Serializable)systemFileVO.getFileTypeId());
        systemFileVO.setFileTypeName(typeEntity.getName());
        return R.data((Object)systemFileVO);
    }

    public R<IPage<SystemFileVO>> pageCondition(SystemFileListDTO req, Query query) {
        2 queryWrapper = new /* Unavailable Anonymous Inner Class!! */;
        IPage pages = super.page(Condition.getPage((Query)query), (Wrapper)queryWrapper);
        List list = SystemFileWrapper.build().listVO(pages.getRecords());
        return R.data((Object)pages.setRecords(list));
    }

    @Transactional(rollbackFor={Exception.class})
    public R submitApproved(SystemFileListDTO req) {
        boolean flag = this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(BaseEntity::getStatus, (Object)req.getStatus())).eq(BaseEntity::getId, (Object)req.getId()));
        if (!flag) {
            throw new ServiceException("\u66f4\u65b0\u6587\u4ef6\u72b6\u6001\u5931\u8d25!");
        }
        if (req.getStatus().equals(Constants.SysFileStatusEnum.PENDING.getStatus())) {
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            R userListR = this.userClient.relationUserListByRoleAlias(this.tenantId, req.getCreateDept(), "SystemFileApprover");
            if (!userListR.isSuccess() || Func.isEmpty((Object)userListR.getData())) {
                throw new ServiceException("\u83b7\u53d6\u4f53\u7cfb\u6587\u4ef6\u5ba1\u6279\u4eba\u89d2\u8272\u4e0b\u7684\u7528\u6237\u5931\u8d25\u6216\u8be5\u89d2\u8272\u4e0b\u7684\u4eba\u5458\u4e3a\u7a7a\uff0c\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff01");
            }
            String approver = ((List)userListR.getData()).stream().map(BaseEntity::getId).map(userId -> "taskUser_".concat(String.valueOf(userId))).collect(Collectors.joining(","));
            params.put("approver", approver);
            params.put("taskId", req.getId());
            R flowR = this.flowClient.startProcessInstanceContainNameByKey("systemFileApprove", FlowUtil.getBusinessKey((String)"hzims_safe_system_file", (String)req.getId().toString()), req.getFileName(), params);
            if (!flowR.isSuccess()) {
                throw new ServiceException(flowR.getMsg());
            }
            this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SystemFileEntity::getFlowId, (Object)((BladeFlow)flowR.getData()).getProcessInstanceId())).eq(BaseEntity::getId, (Object)req.getId()));
        } else {
            ComleteTask comleteTask = new ComleteTask();
            comleteTask.setProcessInstanceId(req.getFlowId());
            comleteTask.setTaskId(req.getTaskId());
            HashMap<String, String> various = new HashMap<String, String>(1);
            comleteTask.setComment(req.getComment());
            if (req.getStatus().equals(Constants.SysFileStatusEnum.APPROVED.getStatus())) {
                comleteTask.setFlag("true");
                various.put("verifyResult", "approved");
            } else if (req.getStatus().equals(Constants.SysFileStatusEnum.REJECT.getStatus())) {
                comleteTask.setFlag("false");
                various.put("verifyResult", "rejected");
            } else {
                throw new ServiceException("status\u4f20\u53c2\u6709\u8bef");
            }
            comleteTask.setVariables(various);
            this.flowClient.completeTask(comleteTask);
        }
        return R.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    public SystemFileServiceImpl(IFlowClient flowClient, IUserClient userClient, ISystemFileTypeService systemFileTypeService) {
        this.flowClient = flowClient;
        this.userClient = userClient;
        this.systemFileTypeService = systemFileTypeService;
    }
}

