/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.utils;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.codec.Base64;
import java.io.IOException;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextImageElement;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;

public class Base64ImgReplacedElementFactory
implements ReplacedElementFactory {
    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if ("img".equals(nodeName)) {
            FSImage fsImage;
            String attribute = e.getAttribute("src");
            try {
                fsImage = this.buildImage(attribute, uac);
            }
            catch (BadElementException e1) {
                fsImage = null;
            }
            catch (IOException e1) {
                fsImage = null;
            }
            if (fsImage != null) {
                if (cssWidth != -1 || cssHeight != -1) {
                    fsImage.scale(cssWidth, cssHeight);
                }
                return new ITextImageElement(fsImage);
            }
        }
        return null;
    }

    protected FSImage buildImage(String srcAttr, UserAgentCallback uac) throws IOException, BadElementException {
        FSImage fiImg = null;
        if (srcAttr.toLowerCase().startsWith("data:image/")) {
            String base64Code = srcAttr.substring(srcAttr.indexOf("base64,") + "base64,".length(), srcAttr.length());
            byte[] decodedBytes = Base64.decode((String)base64Code);
            fiImg = new ITextFSImage(Image.getInstance((byte[])decodedBytes));
        } else {
            fiImg = srcAttr.contains("http") ? uac.getImageResource(srcAttr).getImage() : uac.getImageResource("file:///" + srcAttr).getImage();
        }
        return fiImg;
    }

    public void reset() {
    }

    public void remove(Element arg0) {
    }

    public void setFormSubmissionListener(FormSubmissionListener arg0) {
    }
}

