/*
 * Decompiled with CFR 0.152.
 */
package com.hnac.hzims.safeproduct.wrapper;

import com.hnac.hzims.safeproduct.entity.SafetyToolEntity;
import com.hnac.hzims.safeproduct.entity.SafetyToolTypeEntity;
import com.hnac.hzims.safeproduct.excel.SafetyToolExcel;
import com.hnac.hzims.safeproduct.mapper.SafetyToolTypeMapper;
import com.hnac.hzims.safeproduct.vo.SafetyToolVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springblade.core.mp.base.BaseEntity;
import org.springblade.core.mp.support.BaseEntityWrapper;
import org.springblade.core.tool.utils.BeanUtil;
import org.springblade.core.tool.utils.DateUtil;
import org.springblade.core.tool.utils.Func;
import org.springblade.system.feign.ISysClient;
import org.springblade.system.user.cache.UserCache;
import org.springblade.system.user.entity.User;

public class SafetyToolWrapper
extends BaseEntityWrapper<SafetyToolEntity, SafetyToolVO> {
    public static SafetyToolWrapper build() {
        return new SafetyToolWrapper();
    }

    public SafetyToolVO entityVO(SafetyToolEntity entity) {
        SafetyToolVO vo = (SafetyToolVO)BeanUtil.copy((Object)entity, SafetyToolVO.class);
        User createUser = UserCache.getUser((Long)entity.getCreateUser());
        User updateUser = UserCache.getUser((Long)entity.getUpdateUser());
        vo.setCreateUserName((String)Optional.ofNullable(createUser).map(User::getName).orElse(null));
        vo.setUpdateUserName((String)Optional.ofNullable(updateUser).map(User::getName).orElse(null));
        vo.setLastCheckTimeStr(this.getLastCheckTimeStr(entity));
        vo.setRemainingDays(this.getRemainingDays(entity));
        if (Func.isNotEmpty((Object)entity.getNoticeUsers())) {
            String noticeUserNames = Arrays.asList(entity.getNoticeUsers().split(",")).stream().map(userId -> {
                User user = UserCache.getUser((Long)Long.parseLong(userId));
                return Optional.ofNullable(user).map(User::getName).orElse(null);
            }).collect(Collectors.joining(","));
            vo.setNoticeUsersName(noticeUserNames);
        }
        return vo;
    }

    public List<SafetyToolExcel> entityExcelList(List<SafetyToolEntity> list, ISysClient sysClient, SafetyToolTypeMapper safetyToolTypeMapper) {
        Map<Long, String> toolTypeNames = safetyToolTypeMapper.selectBatchIds((Collection)list.stream().map(SafetyToolEntity::getTypeId).collect(Collectors.toList())).stream().collect(Collectors.toMap(BaseEntity::getId, SafetyToolTypeEntity::getTypeName));
        return list.stream().map(o -> {
            SafetyToolExcel item = new SafetyToolExcel();
            item.setToolName(o.getToolName());
            item.setToolCode(o.getToolCode());
            item.setSafeTime(o.getSafeTime());
            item.setLastCheckTimeStr(this.getLastCheckTimeStr(o));
            item.setToolTypeName((String)toolTypeNames.get(o.getTypeId()));
            if (null != o.getCurSts() && o.getCurSts() > 0L) {
                item.setCurStsStr((String)sysClient.getDeptName(o.getCurSts()).getData());
            }
            return item;
        }).collect(Collectors.toList());
    }

    private Integer getRemainingDays(SafetyToolEntity entity) {
        Date lastCheckTime = entity.getLastCheckTime() == null ? entity.getCreateTime() : entity.getLastCheckTime();
        return (int)((lastCheckTime.getTime() - DateUtil.now().getTime()) / 86400000L);
    }

    private String getLastCheckTimeStr(SafetyToolEntity entity) {
        return entity.getLastCheckTime() == null ? "\u672a\u5f00\u59cb" : DateUtil.formatDateTime((Date)entity.getLastCheckTime());
    }
}

